/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class RangeIterable
implements Iterable<Integer> {
    private final int start;
    private final int count;

    public RangeIterable(int start, int count) {
        this.start = start;
        this.count = count;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int current;
            {
                this.current = RangeIterable.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.current < RangeIterable.this.start + RangeIterable.this.count;
            }

            @Override
            public Integer next() {
                if (this.hasNext()) {
                    return this.current++;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

