/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.internal.operators.Interactive;
import ix.internal.util.SingleContainer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import rx.Notification;

public final class RetryIterable<T>
implements Iterable<T> {
    private final int count;
    private final Iterable<? extends T> source;

    public RetryIterable(int count, Iterable<? extends T> source) {
        this.count = count;
        this.source = source;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int retries;
            final SingleContainer<Notification<? extends T>> peek;
            Iterator<? extends T> it;
            {
                this.retries = RetryIterable.this.count;
                this.peek = new SingleContainer();
                this.it = RetryIterable.this.source.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.peek.isEmpty()) {
                    while (this.it.hasNext()) {
                        try {
                            this.peek.add(Interactive.some(this.it.next()));
                        }
                        catch (Throwable t) {
                            if (this.retries-- > 0) {
                                this.it = RetryIterable.this.source.iterator();
                                continue;
                            }
                            this.peek.add(Interactive.err(t));
                        }
                        break;
                    }
                }
                return !this.peek.isEmpty();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return Interactive.value(this.peek.take());
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }
}

