/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.internal.operators.Interactive;
import ix.internal.util.SingleContainer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import rx.Notification;
import rx.functions.Func2;

public final class ZipIterable<V, T, U>
implements Iterable<V> {
    private final Iterable<? extends U> right;
    private final Func2<? super T, ? super U, ? extends V> combiner;
    private final Iterable<? extends T> left;

    public ZipIterable(Iterable<? extends U> right, Func2<? super T, ? super U, ? extends V> combiner, Iterable<? extends T> left) {
        this.right = right;
        this.combiner = combiner;
        this.left = left;
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            final Iterator<? extends T> ts;
            final Iterator<? extends U> us;
            final SingleContainer<Notification<? extends V>> peek;
            {
                this.ts = ZipIterable.this.left.iterator();
                this.us = ZipIterable.this.right.iterator();
                this.peek = new SingleContainer();
            }

            @Override
            public boolean hasNext() {
                if (this.peek.isEmpty()) {
                    try {
                        if (this.ts.hasNext() && this.us.hasNext()) {
                            this.peek.add(Interactive.some(ZipIterable.this.combiner.call(this.ts.next(), this.us.next())));
                        }
                    }
                    catch (Throwable t) {
                        this.peek.add(Interactive.err(t));
                    }
                }
                return !this.peek.isEmpty();
            }

            @Override
            public V next() {
                if (this.hasNext()) {
                    return Interactive.value(this.peek.take());
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

