/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.math;

import hu.akarnokd.rxjava2.math.FlowableSource;
import hu.akarnokd.rxjava2.util.DeferredScalarSubscriber;
import io.reactivex.exceptions.Exceptions;
import java.util.Comparator;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class FlowableMinMax<T>
extends FlowableSource<T, T> {
    final Comparator<? super T> comparator;
    final int flag;

    public FlowableMinMax(Publisher<T> source, Comparator<? super T> comparator, int flag) {
        super(source);
        this.comparator = comparator;
        this.flag = flag;
    }

    protected void subscribeActual(Subscriber<? super T> observer) {
        this.source.subscribe(new MinMaxSubscriber<T>(observer, this.comparator, this.flag));
    }

    static final class MinMaxSubscriber<T>
    extends DeferredScalarSubscriber<T, T> {
        private static final long serialVersionUID = 600979972678601618L;
        final Comparator<? super T> comparator;
        final int flag;

        public MinMaxSubscriber(Subscriber<? super T> actual, Comparator<? super T> comparator, int flag) {
            super(actual);
            this.comparator = comparator;
            this.flag = flag;
        }

        public void onNext(T value) {
            try {
                if (this.hasValue) {
                    if (this.comparator.compare(this.value, value) * this.flag > 0) {
                        this.value = value;
                    }
                } else {
                    this.value = value;
                    this.hasValue = true;
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.s.cancel();
                this.actual.onError(ex);
            }
        }
    }
}

