/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.math;

import hu.akarnokd.rxjava2.math.FlowableSource;
import hu.akarnokd.rxjava2.util.DeferredScalarSubscriber;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class FlowableSumDouble
extends FlowableSource<Double, Double> {
    public FlowableSumDouble(Publisher<Double> source) {
        super(source);
    }

    protected void subscribeActual(Subscriber<? super Double> observer) {
        this.source.subscribe((Subscriber)new SumDoubleSubscriber(observer));
    }

    static final class SumDoubleSubscriber
    extends DeferredScalarSubscriber<Double, Double> {
        private static final long serialVersionUID = 600979972678601618L;
        double accumulator;

        public SumDoubleSubscriber(Subscriber<? super Double> actual) {
            super(actual);
        }

        public void onNext(Double value) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.accumulator += value.doubleValue();
        }

        @Override
        public void onComplete() {
            if (this.hasValue) {
                this.complete(this.accumulator);
            } else {
                this.actual.onComplete();
            }
        }
    }
}

