/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.math;

import hu.akarnokd.rxjava2.math.FlowableSource;
import hu.akarnokd.rxjava2.util.DeferredScalarSubscriber;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class FlowableSumFloat
extends FlowableSource<Float, Float> {
    public FlowableSumFloat(Publisher<Float> source) {
        super(source);
    }

    protected void subscribeActual(Subscriber<? super Float> observer) {
        this.source.subscribe((Subscriber)new SumFloatSubscriber(observer));
    }

    static final class SumFloatSubscriber
    extends DeferredScalarSubscriber<Float, Float> {
        private static final long serialVersionUID = 600979972678601618L;
        float accumulator;

        public SumFloatSubscriber(Subscriber<? super Float> actual) {
            super(actual);
        }

        public void onNext(Float value) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.accumulator += value.floatValue();
        }

        @Override
        public void onComplete() {
            if (this.hasValue) {
                this.complete(Float.valueOf(this.accumulator));
            } else {
                this.actual.onComplete();
            }
        }
    }
}

