/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.math;

import hu.akarnokd.rxjava2.math.ObservableWithSource;
import hu.akarnokd.rxjava2.util.DeferredScalarObserver;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;

public class ObservableAverageFloat
extends ObservableWithSource<Number, Float> {
    public ObservableAverageFloat(ObservableSource<Number> source) {
        super(source);
    }

    protected void subscribeActual(Observer<? super Float> observer) {
        this.source.subscribe((Observer)new AverageFloatObserver(observer));
    }

    static final class AverageFloatObserver
    extends DeferredScalarObserver<Number, Float> {
        float accumulator;
        int count;

        public AverageFloatObserver(Observer<? super Float> actual) {
            super(actual);
        }

        public void onNext(Number value) {
            ++this.count;
            this.accumulator += value.floatValue();
        }

        @Override
        public void onComplete() {
            int c = this.count;
            if (c != 0) {
                this.complete(Float.valueOf(this.accumulator / (float)c));
            } else {
                this.actual.onComplete();
            }
        }
    }
}

