/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.math;

import hu.akarnokd.rxjava2.math.ObservableWithSource;
import hu.akarnokd.rxjava2.util.DeferredScalarObserver;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import java.util.Comparator;

final class ObservableMinMax<T>
extends ObservableWithSource<T, T> {
    final Comparator<? super T> comparator;
    final int flag;

    public ObservableMinMax(ObservableSource<T> source, Comparator<? super T> comparator, int flag) {
        super(source);
        this.comparator = comparator;
        this.flag = flag;
    }

    protected void subscribeActual(Observer<? super T> observer) {
        this.source.subscribe(new MinMaxSubscriber<T>(observer, this.comparator, this.flag));
    }

    static final class MinMaxSubscriber<T>
    extends DeferredScalarObserver<T, T> {
        final Comparator<? super T> comparator;
        final int flag;

        public MinMaxSubscriber(Observer<? super T> actual, Comparator<? super T> comparator, int flag) {
            super(actual);
            this.comparator = comparator;
            this.flag = flag;
        }

        public void onNext(T value) {
            try {
                if (this.hasValue) {
                    if (this.comparator.compare(this.value, value) * this.flag > 0) {
                        this.value = value;
                    }
                } else {
                    this.value = value;
                    this.hasValue = true;
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.s.dispose();
                this.actual.onError(ex);
            }
        }
    }
}

