/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.math;

import hu.akarnokd.rxjava2.math.ObservableWithSource;
import hu.akarnokd.rxjava2.util.DeferredScalarObserver;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;

public class ObservableSumDouble
extends ObservableWithSource<Double, Double> {
    public ObservableSumDouble(ObservableSource<Double> source) {
        super(source);
    }

    protected void subscribeActual(Observer<? super Double> observer) {
        this.source.subscribe((Observer)new SumDoubleObserver(observer));
    }

    static final class SumDoubleObserver
    extends DeferredScalarObserver<Double, Double> {
        double accumulator;

        public SumDoubleObserver(Observer<? super Double> actual) {
            super(actual);
        }

        public void onNext(Double value) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.accumulator += value.doubleValue();
        }

        @Override
        public void onComplete() {
            if (this.hasValue) {
                this.complete(this.accumulator);
            } else {
                this.actual.onComplete();
            }
        }
    }
}

