/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.math;

import hu.akarnokd.rxjava2.math.ObservableWithSource;
import hu.akarnokd.rxjava2.util.DeferredScalarObserver;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;

public class ObservableSumLong
extends ObservableWithSource<Long, Long> {
    public ObservableSumLong(ObservableSource<Long> source) {
        super(source);
    }

    protected void subscribeActual(Observer<? super Long> observer) {
        this.source.subscribe((Observer)new SumLongObserver(observer));
    }

    static final class SumLongObserver
    extends DeferredScalarObserver<Long, Long> {
        long accumulator;

        public SumLongObserver(Observer<? super Long> actual) {
            super(actual);
        }

        public void onNext(Long value) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.accumulator += value.longValue();
        }

        @Override
        public void onComplete() {
            if (this.hasValue) {
                this.complete(this.accumulator);
            } else {
                this.actual.onComplete();
            }
        }
    }
}

