/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.util;

import hu.akarnokd.rxjava2.util.BaseQueueDisposable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;

public abstract class DeferredScalarObserver<T, R>
extends BaseQueueDisposable<R>
implements Observer<T> {
    protected final Observer<? super R> actual;
    protected Disposable s;
    protected boolean hasValue;
    protected R value;
    protected int fusionState;
    static final int NOT_FUSED = 0;
    static final int EMPTY = 1;
    static final int READY = 2;
    static final int CONSUMED = 3;
    volatile boolean disposed;

    public DeferredScalarObserver(Observer<? super R> actual) {
        this.actual = actual;
    }

    public void onSubscribe(Disposable s) {
        if (DisposableHelper.validate((Disposable)this.s, (Disposable)s)) {
            this.s = s;
            this.actual.onSubscribe((Disposable)this);
        }
    }

    public void onError(Throwable t) {
        this.value = null;
        this.actual.onError(t);
    }

    public void onComplete() {
        if (this.hasValue) {
            this.complete(this.value);
        } else {
            this.actual.onComplete();
        }
    }

    protected final void complete(R value) {
        if (this.disposed) {
            return;
        }
        if (this.fusionState == 1) {
            this.fusionState = 2;
            this.value = value;
        }
        this.actual.onNext(value);
        if (this.disposed) {
            return;
        }
        this.actual.onComplete();
    }

    public final R poll() {
        if (this.fusionState == 2) {
            this.fusionState = 3;
            return this.value;
        }
        return null;
    }

    public final boolean isDisposed() {
        return this.disposed;
    }

    public final void dispose() {
        this.disposed = true;
        this.s.dispose();
    }

    public final boolean isEmpty() {
        return this.fusionState != 2;
    }

    public final int requestFusion(int mode) {
        return mode & 2;
    }

    public void clear() {
        this.value = null;
        this.fusionState = 3;
    }
}

