/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Perhaps;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class PerhapsDelayPublisher<T>
extends Perhaps<T> {
    final Perhaps<T> source;
    final Publisher<?> other;

    PerhapsDelayPublisher(Perhaps<T> source, Publisher<?> other) {
        this.source = source;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new DelaySubscriber<T>(s, this.other));
    }

    static final class DelaySubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -9119999967998769573L;
        final Publisher<?> other;
        final OtherSubscriber otherSubscriber;
        Subscription s;
        Throwable error;

        DelaySubscriber(Subscriber<? super T> actual, Publisher<?> other) {
            super(actual);
            this.other = other;
            this.otherSubscriber = new OtherSubscriber();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            this.error = t;
            this.other.subscribe((Subscriber)this.otherSubscriber);
        }

        public void onComplete() {
            this.other.subscribe((Subscriber)this.otherSubscriber);
        }

        void otherSignal() {
            Throwable ex = this.error;
            if (ex != null) {
                this.actual.onError(ex);
                return;
            }
            Object v = this.value;
            if (v != null) {
                this.complete(v);
            } else {
                this.actual.onComplete();
            }
        }

        void otherError(Throwable t) {
            Throwable ex = this.error;
            if (ex != null) {
                t = new CompositeException(new Throwable[]{ex, t});
            }
            this.actual.onError(t);
        }

        public void cancel() {
            super.cancel();
            this.s.cancel();
            SubscriptionHelper.cancel((AtomicReference)this.otherSubscriber);
        }

        final class OtherSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<Object> {
            private static final long serialVersionUID = -6651374802328276829L;

            OtherSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(Object t) {
                ((Subscription)this.get()).cancel();
                this.lazySet(SubscriptionHelper.CANCELLED);
                DelaySubscriber.this.otherSignal();
            }

            public void onError(Throwable t) {
                if (this.get() != SubscriptionHelper.CANCELLED) {
                    DelaySubscriber.this.otherError(t);
                } else {
                    RxJavaPlugins.onError((Throwable)t);
                }
            }

            public void onComplete() {
                if (this.get() != SubscriptionHelper.CANCELLED) {
                    DelaySubscriber.this.otherSignal();
                }
            }
        }
    }
}

