/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Solo;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloFlatMap<T, R>
extends Solo<R> {
    final Solo<T> source;
    final Function<? super T, ? extends Solo<? extends R>> mapper;

    SoloFlatMap(Solo<T> source, Function<? super T, ? extends Solo<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new FlatMapSubscriber<T, R>(s, this.mapper));
    }

    static final class FlatMapSubscriber<T, R>
    extends DeferredScalarSubscription<R>
    implements Subscriber<T> {
        private static final long serialVersionUID = -7631998337002592538L;
        final Function<? super T, ? extends Solo<? extends R>> mapper;
        final NextSubscriber nextSubscriber;
        Subscription s;

        FlatMapSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends Solo<? extends R>> mapper) {
            super(actual);
            this.mapper = mapper;
            this.nextSubscriber = new NextSubscriber();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            Solo sp;
            try {
                sp = (Solo)ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper returned a null Solo");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.actual.onError(ex);
                return;
            }
            sp.subscribe(this.nextSubscriber);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
        }

        public void cancel() {
            super.cancel();
            this.s.cancel();
            SubscriptionHelper.cancel((AtomicReference)this.nextSubscriber);
        }

        void nextComplete() {
            this.complete(this.value);
        }

        final class NextSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<R> {
            private static final long serialVersionUID = 5161815655607865861L;

            NextSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(R t) {
                FlatMapSubscriber.this.value = t;
            }

            public void onError(Throwable t) {
                FlatMapSubscriber.this.actual.onError(t);
            }

            public void onComplete() {
                FlatMapSubscriber.this.nextComplete();
            }
        }
    }
}

