/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Solo;
import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloFlatMapPublisher<T, R>
extends Flowable<R> {
    final Solo<T> source;
    final Function<? super T, ? extends Publisher<? extends R>> mapper;

    SoloFlatMapPublisher(Solo<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new FlatMapPublisherSubscriber<T, R>(s, this.mapper));
    }

    static final class FlatMapPublisherSubscriber<T, R>
    extends AtomicReference<Subscription>
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = -3958458353930920644L;
        final Subscriber<? super R> actual;
        final InnerSubscriber requested;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        Subscription s;

        FlatMapPublisherSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper) {
            this.actual = actual;
            this.mapper = mapper;
            this.requested = new InnerSubscriber(actual);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            Publisher p;
            try {
                p = (Publisher)ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper returned a null Publisher");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.actual.onError(ex);
                return;
            }
            p.subscribe((Subscriber)this.requested);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
        }

        public void cancel() {
            this.s.cancel();
            SubscriptionHelper.cancel((AtomicReference)this);
        }

        public void request(long n) {
            SubscriptionHelper.deferredRequest((AtomicReference)this, (AtomicLong)this.requested, (long)n);
        }

        final class InnerSubscriber
        extends AtomicLong
        implements Subscriber<R> {
            private static final long serialVersionUID = 2003600104149898338L;
            final Subscriber<? super R> actual;

            InnerSubscriber(Subscriber<? super R> actual) {
                this.actual = actual;
            }

            public void onSubscribe(Subscription s) {
                SubscriptionHelper.deferredSetOnce((AtomicReference)FlatMapPublisherSubscriber.this, (AtomicLong)FlatMapPublisherSubscriber.this.requested, (Subscription)s);
            }

            public void onNext(R t) {
                this.actual.onNext(t);
            }

            public void onError(Throwable t) {
                this.actual.onError(t);
            }

            public void onComplete() {
                this.actual.onComplete();
            }
        }
    }
}

