/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Solo;
import hu.akarnokd.rxjava2.basetypes.SoloMap;
import hu.akarnokd.rxjava2.basetypes.SoloZipArray;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.EmptySubscription;
import java.util.Arrays;
import org.reactivestreams.Subscriber;

final class SoloZipIterable<T, R>
extends Solo<R>
implements Function<T, R> {
    final Iterable<? extends Solo<? extends T>> sources;
    final Function<? super Object[], ? extends R> zipper;

    SoloZipIterable(Iterable<? extends Solo<? extends T>> sources, Function<? super Object[], ? extends R> zipper) {
        this.sources = sources;
        this.zipper = zipper;
    }

    public R apply(T t) throws Exception {
        return (R)this.zipper.apply((Object)new Object[]{t});
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        int n = 0;
        Solo[] array = new Solo[8];
        try {
            for (Solo<? extends T> solo : this.sources) {
                if (n == array.length) {
                    array = Arrays.copyOf(array, n + (n >> 1));
                }
                array[n++] = (Solo)ObjectHelper.requireNonNull(solo, (String)"One of the source Solo is null");
            }
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptySubscription.error((Throwable)ex, s);
            return;
        }
        if (n == 0) {
            EmptySubscription.complete(s);
            return;
        }
        if (n == 1) {
            array[0].subscribe(new SoloMap.MapSubscriber(s, this));
            return;
        }
        SoloZipArray.ZipCoordinator parent = new SoloZipArray.ZipCoordinator(s, this.zipper, n);
        s.onSubscribe(parent);
        parent.subscribe(array, n);
    }
}

