/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableBufferPredicate<T, C extends Collection<? super T>>
extends Flowable<C>
implements FlowableTransformer<T, C> {
    final Publisher<T> source;
    final Predicate<? super T> predicate;
    final boolean cutAfter;
    final Callable<C> bufferSupplier;

    FlowableBufferPredicate(Publisher<T> source, Predicate<? super T> predicate, boolean cutAfter, Callable<C> bufferSupplier) {
        this.source = source;
        this.predicate = predicate;
        this.cutAfter = cutAfter;
        this.bufferSupplier = bufferSupplier;
    }

    protected void subscribeActual(Subscriber<? super C> s) {
        Collection buffer;
        try {
            buffer = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), (String)"The bufferSupplier returned a null buffer");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptySubscription.error((Throwable)ex, s);
            return;
        }
        this.source.subscribe(new BufferPredicateSubscriber<T, Collection>(s, buffer, this.predicate, this.cutAfter, this.bufferSupplier));
    }

    public Publisher<C> apply(Flowable<T> upstream) {
        return new FlowableBufferPredicate<T, C>(upstream, this.predicate, this.cutAfter, this.bufferSupplier);
    }

    static final class BufferPredicateSubscriber<T, C extends Collection<? super T>>
    implements ConditionalSubscriber<T>,
    Subscription {
        final Subscriber<? super C> actual;
        final Predicate<? super T> predicate;
        final boolean cutAfter;
        final Callable<C> bufferSupplier;
        C buffer;
        Subscription s;
        int count;

        BufferPredicateSubscriber(Subscriber<? super C> actual, C buffer, Predicate<? super T> predicate, boolean cutAfter, Callable<C> bufferSupplier) {
            this.actual = actual;
            this.predicate = predicate;
            this.cutAfter = cutAfter;
            this.buffer = buffer;
            this.bufferSupplier = bufferSupplier;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean tryOnNext(T t) {
            Collection collection;
            boolean b;
            C c = this.buffer;
            if (c == null) return true;
            try {
                b = this.predicate.test(t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.s.cancel();
                this.buffer = null;
                this.actual.onError(ex);
                return true;
            }
            if (this.cutAfter) {
                c.add(t);
                if (b) {
                    this.actual.onNext(c);
                    try {
                        this.buffer = (Collection)this.bufferSupplier.call();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        this.s.cancel();
                        this.onError(ex);
                        return true;
                    }
                    this.count = 0;
                    return true;
                }
                ++this.count;
                return false;
            }
            if (b) {
                c.add(t);
                ++this.count;
                return false;
            }
            this.actual.onNext(c);
            try {
                collection = (Collection)this.bufferSupplier.call();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.s.cancel();
                this.onError(ex);
                return true;
            }
            collection.add(t);
            this.buffer = collection;
            this.count = 1;
            return true;
        }

        public void onError(Throwable t) {
            if (this.buffer != null) {
                this.buffer = null;
                this.actual.onError(t);
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            C b = this.buffer;
            if (b != null) {
                this.buffer = null;
                if (this.count != 0) {
                    this.actual.onNext(b);
                }
                this.actual.onComplete();
            }
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

