/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Scheduler;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.ArrayDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableOnBackpressureTimeout<T>
extends Flowable<T>
implements FlowableTransformer<T, T> {
    final Publisher<T> source;
    final int maxSize;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Consumer<? super T> onEvict;

    FlowableOnBackpressureTimeout(Publisher<T> source, int maxSize, long timeout, TimeUnit unit, Scheduler scheduler, Consumer<? super T> onEvict) {
        this.source = source;
        this.maxSize = maxSize;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.onEvict = onEvict;
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableOnBackpressureTimeout<T>(upstream, this.maxSize, this.timeout, this.unit, this.scheduler, this.onEvict);
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new OnBackpressureTimeoutSubscriber<T>(s, this.maxSize, this.timeout, this.unit, this.scheduler.createWorker(), this.onEvict));
    }

    static final class OnBackpressureTimeoutSubscriber<T>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 2264324530873250941L;
        final Subscriber<? super T> actual;
        final AtomicLong requested;
        final int maxSizeDouble;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final Consumer<? super T> onEvict;
        Subscription s;
        final ArrayDeque<Object> queue;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;

        OnBackpressureTimeoutSubscriber(Subscriber<? super T> actual, int maxSize, long timeout, TimeUnit unit, Scheduler.Worker worker, Consumer<? super T> onEvict) {
            this.actual = actual;
            this.maxSizeDouble = maxSize << 1;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.onEvict = onEvict;
            this.requested = new AtomicLong();
            this.queue = new ArrayDeque();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.drain();
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.s.cancel();
            this.worker.dispose();
            if (this.getAndIncrement() == 0) {
                this.clearQueue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearQueue() {
            while (true) {
                Object evicted;
                OnBackpressureTimeoutSubscriber onBackpressureTimeoutSubscriber = this;
                synchronized (onBackpressureTimeoutSubscriber) {
                    if (this.queue.isEmpty()) {
                        break;
                    }
                    this.queue.poll();
                    evicted = this.queue.poll();
                }
                this.evict(evicted);
            }
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            Object evicted = null;
            OnBackpressureTimeoutSubscriber onBackpressureTimeoutSubscriber = this;
            synchronized (onBackpressureTimeoutSubscriber) {
                if (this.queue.size() == this.maxSizeDouble) {
                    this.queue.poll();
                    evicted = this.queue.poll();
                }
                this.queue.offer(this.worker.now(this.unit));
                this.queue.offer(t);
            }
            this.evict(evicted);
            this.worker.schedule((Runnable)this, this.timeout, this.unit);
            this.drain();
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.cancelled) {
                boolean empty;
                boolean d = this.done;
                Object evicted = null;
                OnBackpressureTimeoutSubscriber onBackpressureTimeoutSubscriber = this;
                synchronized (onBackpressureTimeoutSubscriber) {
                    Long ts = (Long)this.queue.peek();
                    boolean bl = empty = ts == null;
                    if (!empty) {
                        if (ts <= this.worker.now(this.unit) - this.timeout) {
                            this.queue.poll();
                            evicted = this.queue.poll();
                        } else {
                            break;
                        }
                    }
                }
                this.evict(evicted);
                if (!empty) continue;
                if (!d) break;
                this.drain();
                break;
            }
        }

        void evict(T evicted) {
            if (evicted != null) {
                try {
                    this.onEvict.accept(evicted);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    RxJavaPlugins.onError((Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            do {
                boolean empty;
                boolean d;
                long e;
                long r = this.requested.get();
                for (e = 0L; e != r; ++e) {
                    boolean empty2;
                    Object v;
                    if (this.cancelled) {
                        this.clearQueue();
                        return;
                    }
                    d = this.done;
                    OnBackpressureTimeoutSubscriber onBackpressureTimeoutSubscriber = this;
                    synchronized (onBackpressureTimeoutSubscriber) {
                        v = this.queue.poll() != null ? this.queue.poll() : null;
                    }
                    boolean bl = empty2 = v == null;
                    if (d && empty2) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.actual.onError(ex);
                        } else {
                            this.actual.onComplete();
                        }
                        this.worker.dispose();
                        return;
                    }
                    if (empty2) break;
                    this.actual.onNext(v);
                }
                if (e != r) continue;
                if (this.cancelled) {
                    this.clearQueue();
                    return;
                }
                d = this.done;
                OnBackpressureTimeoutSubscriber empty2 = this;
                synchronized (empty2) {
                    empty = this.queue.isEmpty();
                }
                if (!d || !empty) continue;
                Throwable ex = this.error;
                if (ex != null) {
                    this.actual.onError(ex);
                } else {
                    this.actual.onComplete();
                }
                this.worker.dispose();
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

