/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.subscriptions.BasicQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;

final class FlowableRepeatCallable<T>
extends Flowable<T> {
    final Callable<T> callable;

    FlowableRepeatCallable(Callable<T> callable) {
        this.callable = callable;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        if (s instanceof ConditionalSubscriber) {
            s.onSubscribe(new RepeatCallableConditionalSubscription<T>((ConditionalSubscriber)s, this.callable));
        } else {
            s.onSubscribe(new RepeatCallableSubscription<T>(s, this.callable));
        }
    }

    static final class RepeatCallableConditionalSubscription<T>
    extends BasicQueueSubscription<T> {
        private static final long serialVersionUID = -231033913007168200L;
        final ConditionalSubscriber<? super T> actual;
        final Callable<T> callable;
        volatile boolean cancelled;

        RepeatCallableConditionalSubscription(ConditionalSubscriber<? super T> actual, Callable<T> callable) {
            this.actual = actual;
            this.callable = callable;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n) && BackpressureHelper.add((AtomicLong)((Object)this), (long)n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastpath();
                } else {
                    this.slowpath(n);
                }
            }
        }

        void fastpath() {
            Callable<T> c = this.callable;
            while (!this.cancelled) {
                Object v;
                try {
                    v = ObjectHelper.requireNonNull(c.call(), (String)"The callable returned a null value");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.actual.onError(ex);
                    break;
                }
                this.actual.tryOnNext(v);
            }
        }

        void slowpath(long r) {
            Callable<T> c = this.callable;
            long e = 0L;
            while (true) {
                if (e != r) {
                    Object v;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        v = ObjectHelper.requireNonNull(c.call(), (String)"The callable returned a null value");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        this.actual.onError(ex);
                        return;
                    }
                    if (!this.actual.tryOnNext(v)) continue;
                    ++e;
                    continue;
                }
                if (this.cancelled) {
                    return;
                }
                r = this.get();
                if (e == r && (r = this.addAndGet(-e)) == 0L) break;
            }
        }

        public void cancel() {
            this.cancelled = true;
        }

        public int requestFusion(int mode) {
            return mode & 1;
        }

        public T poll() throws Exception {
            return (T)ObjectHelper.requireNonNull(this.callable.call(), (String)"The callable returned a null value");
        }

        public boolean isEmpty() {
            return false;
        }

        public void clear() {
        }
    }

    static final class RepeatCallableSubscription<T>
    extends BasicQueueSubscription<T> {
        private static final long serialVersionUID = -231033913007168200L;
        final Subscriber<? super T> actual;
        final Callable<T> callable;
        volatile boolean cancelled;

        RepeatCallableSubscription(Subscriber<? super T> actual, Callable<T> callable) {
            this.actual = actual;
            this.callable = callable;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n) && BackpressureHelper.add((AtomicLong)((Object)this), (long)n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastpath();
                } else {
                    this.slowpath(n);
                }
            }
        }

        void fastpath() {
            Callable<T> c = this.callable;
            while (!this.cancelled) {
                Object v;
                try {
                    v = ObjectHelper.requireNonNull(c.call(), (String)"The callable returned a null value");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.actual.onError(ex);
                    break;
                }
                this.actual.onNext(v);
            }
        }

        void slowpath(long r) {
            Callable<T> c = this.callable;
            long e = 0L;
            while (true) {
                if (e != r) {
                    Object v;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        v = ObjectHelper.requireNonNull(c.call(), (String)"The callable returned a null value");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        this.actual.onError(ex);
                        return;
                    }
                    this.actual.onNext(v);
                    ++e;
                    continue;
                }
                if (this.cancelled) {
                    return;
                }
                r = this.get();
                if (e == r && (r = this.addAndGet(-e)) == 0L) break;
            }
        }

        public void cancel() {
            this.cancelled = true;
        }

        public int requestFusion(int mode) {
            return mode & 1;
        }

        public T poll() throws Exception {
            return (T)ObjectHelper.requireNonNull(this.callable.call(), (String)"The callable returned a null value");
        }

        public boolean isEmpty() {
            return false;
        }

        public void clear() {
        }
    }
}

