/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import hu.akarnokd.rxjava2.operators.BasicEmitter;
import hu.akarnokd.rxjava2.operators.FlowableBufferPredicate;
import hu.akarnokd.rxjava2.operators.FlowableEvery;
import hu.akarnokd.rxjava2.operators.FlowableMapFilter;
import hu.akarnokd.rxjava2.operators.FlowableOnBackpressureTimeout;
import hu.akarnokd.rxjava2.operators.FlowableSpanout;
import hu.akarnokd.rxjava2.operators.FlowableValve;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Scheduler;
import io.reactivex.annotations.BackpressureKind;
import io.reactivex.annotations.BackpressureSupport;
import io.reactivex.annotations.SchedulerSupport;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.schedulers.Schedulers;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;

public final class FlowableTransformers {
    private FlowableTransformers() {
        throw new IllegalStateException("No instances!");
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    public static <T> FlowableTransformer<T, T> valve(Publisher<Boolean> other) {
        return FlowableTransformers.valve(other, true, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    public static <T> FlowableTransformer<T, T> valve(Publisher<Boolean> other, boolean defaultOpen) {
        return FlowableTransformers.valve(other, defaultOpen, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    public static <T> FlowableTransformer<T, T> valve(Publisher<Boolean> other, boolean defaultOpen, int bufferSize) {
        ObjectHelper.requireNonNull(other, (String)"other is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return new FlowableValve(null, other, defaultOpen, bufferSize);
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T> FlowableTransformer<T, List<T>> bufferWhile(Predicate<? super T> predicate) {
        return FlowableTransformers.bufferWhile(predicate, Functions.createArrayList((int)16));
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, C extends Collection<? super T>> FlowableTransformer<T, C> bufferWhile(Predicate<? super T> predicate, Callable<C> bufferSupplier) {
        return new FlowableBufferPredicate<T, C>(null, predicate, false, bufferSupplier);
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T> FlowableTransformer<T, List<T>> bufferUntil(Predicate<? super T> predicate) {
        return FlowableTransformers.bufferUntil(predicate, Functions.createArrayList((int)16));
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, C extends Collection<? super T>> FlowableTransformer<T, C> bufferUntil(Predicate<? super T> predicate, Callable<C> bufferSupplier) {
        return new FlowableBufferPredicate<T, C>(null, predicate, true, bufferSupplier);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="io.reactivex:computation")
    public static <T> FlowableTransformer<T, T> spanout(long betweenDelay, TimeUnit unit) {
        return FlowableTransformers.spanout(0L, betweenDelay, unit, Schedulers.computation(), false);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    public static <T> FlowableTransformer<T, T> spanout(long betweenDelay, TimeUnit unit, Scheduler scheduler) {
        return FlowableTransformers.spanout(0L, betweenDelay, unit, scheduler, false);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="io.reactivex:computation")
    public static <T> FlowableTransformer<T, T> spanout(long initialDelay, long betweenDelay, TimeUnit unit) {
        return FlowableTransformers.spanout(initialDelay, betweenDelay, unit, Schedulers.computation(), false);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    public static <T> FlowableTransformer<T, T> spanout(long initialDelay, long betweenDelay, TimeUnit unit, Scheduler scheduler) {
        return FlowableTransformers.spanout(initialDelay, betweenDelay, unit, scheduler, false);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="io.reactivex:computation")
    public static <T> FlowableTransformer<T, T> spanout(long betweenDelay, TimeUnit unit, boolean delayError) {
        return FlowableTransformers.spanout(0L, betweenDelay, unit, Schedulers.computation(), delayError);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    public static <T> FlowableTransformer<T, T> spanout(long betweenDelay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        return FlowableTransformers.spanout(0L, betweenDelay, unit, scheduler, delayError);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="io.reactivex:computation")
    public static <T> FlowableTransformer<T, T> spanout(long initialDelay, long betweenDelay, TimeUnit unit, boolean delayError) {
        return FlowableTransformers.spanout(initialDelay, betweenDelay, unit, Schedulers.computation(), delayError);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    public static <T> FlowableTransformer<T, T> spanout(long initialDelay, long betweenDelay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return new FlowableSpanout(null, initialDelay, betweenDelay, unit, scheduler, delayError, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T, R> FlowableTransformer<T, R> mapFilter(BiConsumer<? super T, ? super BasicEmitter<R>> consumer) {
        ObjectHelper.requireNonNull(consumer, (String)"consumer is null");
        return new FlowableMapFilter(null, consumer);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="io.reactivex:computation")
    public static <T> FlowableTransformer<T, T> onBackpressureTimeout(long timeout, TimeUnit unit) {
        return FlowableTransformers.onBackpressureTimeout(timeout, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    public static <T> FlowableTransformer<T, T> onBackpressureTimeout(long timeout, TimeUnit unit, Scheduler scheduler, Consumer<? super T> onEvict) {
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        ObjectHelper.requireNonNull(onEvict, (String)"onEvict is null");
        return new FlowableOnBackpressureTimeout<T>(null, Integer.MAX_VALUE, timeout, unit, scheduler, onEvict);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    public static <T> FlowableTransformer<T, T> onBackpressureTimeout(long timeout, TimeUnit unit, Scheduler scheduler) {
        return FlowableTransformers.onBackpressureTimeout(Integer.MAX_VALUE, timeout, unit, scheduler, Functions.emptyConsumer());
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    public static <T> FlowableTransformer<T, T> onBackpressureTimeout(int maxSize, long timeout, TimeUnit unit, Scheduler scheduler, Consumer<? super T> onEvict) {
        ObjectHelper.verifyPositive((int)maxSize, (String)"maxSize");
        ObjectHelper.requireNonNull((Object)((Object)unit), (String)"unit is null");
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        ObjectHelper.requireNonNull(onEvict, (String)"onEvict is null");
        return new FlowableOnBackpressureTimeout<T>(null, maxSize, timeout, unit, scheduler, onEvict);
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public static <T> FlowableTransformer<T, T> every(long keep) {
        ObjectHelper.verifyPositive((long)keep, (String)"keep");
        return new FlowableEvery(null, keep);
    }
}

