/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.parallel;

import hu.akarnokd.rxjava2.parallel.ParallelFlowable;
import io.reactivex.functions.Function;
import io.reactivex.internal.operators.flowable.FlowableFlatMap;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class ParallelFlatMap<T, R>
extends ParallelFlowable<R> {
    final ParallelFlowable<T> source;
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final boolean delayError;
    final int maxConcurrency;
    final int prefetch;

    ParallelFlatMap(ParallelFlowable<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayError, int maxConcurrency, int prefetch) {
        this.source = source;
        this.mapper = mapper;
        this.delayError = delayError;
        this.maxConcurrency = maxConcurrency;
        this.prefetch = prefetch;
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        final Subscriber[] parents = new Subscriber[n];
        Publisher p = new Publisher<T>(){
            int i;

            public void subscribe(Subscriber<? super T> s) {
                parents[this.i++] = s;
            }
        };
        FlowableFlatMap op = new FlowableFlatMap(p, this.mapper, this.delayError, this.maxConcurrency, this.prefetch);
        for (int i = 0; i < n; ++i) {
            op.subscribe(subscribers[i]);
        }
        this.source.subscribe(parents);
    }
}

