/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.string;

import hu.akarnokd.rxjava2.string.FlowableCharSequence;
import hu.akarnokd.rxjava2.string.FlowableSplit;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.regex.Pattern;

public final class StringFlowable {
    private StringFlowable() {
        throw new IllegalStateException("No instances!");
    }

    public static Flowable<Integer> characters(CharSequence string) {
        ObjectHelper.requireNonNull((Object)string, (String)"string is null");
        return RxJavaPlugins.onAssembly((Flowable)new FlowableCharSequence(string));
    }

    public static FlowableTransformer<String, String> split(Pattern pattern) {
        return StringFlowable.split(pattern, Flowable.bufferSize());
    }

    public static FlowableTransformer<String, String> split(Pattern pattern, int bufferSize) {
        ObjectHelper.requireNonNull((Object)pattern, (String)"pattern is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return new FlowableSplit(null, pattern, bufferSize);
    }

    public static FlowableTransformer<String, String> split(String pattern) {
        return StringFlowable.split(pattern, Flowable.bufferSize());
    }

    public static FlowableTransformer<String, String> split(String pattern, int bufferSize) {
        return StringFlowable.split(Pattern.compile(pattern), bufferSize);
    }
}

