/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.subjects;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableSubject
extends Completable
implements CompletableObserver {
    final AtomicReference<CompletableDisposable[]> observers;
    static final CompletableDisposable[] EMPTY = new CompletableDisposable[0];
    static final CompletableDisposable[] TERMINATED = new CompletableDisposable[0];
    final AtomicBoolean once = new AtomicBoolean();
    Throwable error;

    public static CompletableSubject create() {
        return new CompletableSubject();
    }

    CompletableSubject() {
        this.observers = new AtomicReference<CompletableDisposable[]>(EMPTY);
    }

    public void onSubscribe(Disposable d) {
        if (this.observers.get() == TERMINATED) {
            d.dispose();
        }
    }

    public void onError(Throwable e) {
        if (e == null) {
            e = new NullPointerException("Null errors are not allowed in 2.x");
        }
        if (this.once.compareAndSet(false, true)) {
            this.error = e;
            for (CompletableDisposable md : this.observers.getAndSet(TERMINATED)) {
                md.actual.onError(e);
            }
        } else {
            RxJavaPlugins.onError((Throwable)e);
        }
    }

    public void onComplete() {
        if (this.once.compareAndSet(false, true)) {
            for (CompletableDisposable md : this.observers.getAndSet(TERMINATED)) {
                md.actual.onComplete();
            }
        }
    }

    protected void subscribeActual(CompletableObserver observer) {
        CompletableDisposable md = new CompletableDisposable(observer, this);
        observer.onSubscribe((Disposable)md);
        if (this.add(md)) {
            if (md.isDisposed()) {
                this.remove(md);
            }
        } else {
            Throwable ex = this.error;
            if (ex != null) {
                observer.onError(ex);
            } else {
                observer.onComplete();
            }
        }
    }

    boolean add(CompletableDisposable inner) {
        CompletableDisposable[] b;
        CompletableDisposable[] a;
        do {
            if ((a = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new CompletableDisposable[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner;
        } while (!this.observers.compareAndSet(a, b));
        return true;
    }

    void remove(CompletableDisposable inner) {
        CompletableDisposable[] b;
        CompletableDisposable[] a;
        do {
            int n;
            if ((n = (a = this.observers.get()).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != inner) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new CompletableDisposable[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!this.observers.compareAndSet(a, b));
    }

    public Throwable getThrowable() {
        if (this.observers.get() == TERMINATED) {
            return this.error;
        }
        return null;
    }

    public boolean hasThrowable() {
        return this.observers.get() == TERMINATED && this.error != null;
    }

    public boolean hasComplete() {
        return this.observers.get() == TERMINATED && this.error == null;
    }

    public boolean hasObservers() {
        return this.observers.get().length != 0;
    }

    int observerCount() {
        return this.observers.get().length;
    }

    static final class CompletableDisposable
    extends AtomicReference<CompletableSubject>
    implements Disposable {
        private static final long serialVersionUID = -7650903191002190468L;
        final CompletableObserver actual;

        CompletableDisposable(CompletableObserver actual, CompletableSubject parent) {
            this.actual = actual;
            this.lazySet(parent);
        }

        public void dispose() {
            CompletableSubject parent = this.getAndSet(null);
            if (parent != null) {
                parent.remove(this);
            }
        }

        public boolean isDisposed() {
            return this.get() == null;
        }
    }
}

