/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.subjects;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeSubject<T>
extends Maybe<T>
implements MaybeObserver<T> {
    final AtomicReference<MaybeDisposable<T>[]> observers;
    static final MaybeDisposable[] EMPTY = new MaybeDisposable[0];
    static final MaybeDisposable[] TERMINATED = new MaybeDisposable[0];
    final AtomicBoolean once = new AtomicBoolean();
    T value;
    Throwable error;

    public static <T> MaybeSubject<T> create() {
        return new MaybeSubject<T>();
    }

    MaybeSubject() {
        this.observers = new AtomicReference<MaybeDisposable[]>(EMPTY);
    }

    public void onSubscribe(Disposable d) {
        if (this.observers.get() == TERMINATED) {
            d.dispose();
        }
    }

    public void onSuccess(T value) {
        if (value == null) {
            this.onError(new NullPointerException("Null values are not allowed in 2.x"));
            return;
        }
        if (this.once.compareAndSet(false, true)) {
            this.value = value;
            for (MaybeDisposable md : this.observers.getAndSet(TERMINATED)) {
                md.actual.onSuccess(value);
            }
        }
    }

    public void onError(Throwable e) {
        if (e == null) {
            e = new NullPointerException("Null errors are not allowed in 2.x");
        }
        if (this.once.compareAndSet(false, true)) {
            this.error = e;
            for (MaybeDisposable md : this.observers.getAndSet(TERMINATED)) {
                md.actual.onError(e);
            }
        } else {
            RxJavaPlugins.onError((Throwable)e);
        }
    }

    public void onComplete() {
        if (this.once.compareAndSet(false, true)) {
            for (MaybeDisposable md : this.observers.getAndSet(TERMINATED)) {
                md.actual.onComplete();
            }
        }
    }

    protected void subscribeActual(MaybeObserver<? super T> observer) {
        MaybeDisposable<T> md = new MaybeDisposable<T>(observer, this);
        observer.onSubscribe(md);
        if (this.add(md)) {
            if (md.isDisposed()) {
                this.remove(md);
            }
        } else {
            Throwable ex = this.error;
            if (ex != null) {
                observer.onError(ex);
            } else {
                T v = this.value;
                if (v == null) {
                    observer.onComplete();
                } else {
                    observer.onSuccess(v);
                }
            }
        }
    }

    boolean add(MaybeDisposable<T> inner) {
        MaybeDisposable[] b;
        MaybeDisposable<T>[] a;
        do {
            if ((a = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new MaybeDisposable[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner;
        } while (!this.observers.compareAndSet(a, b));
        return true;
    }

    void remove(MaybeDisposable<T> inner) {
        MaybeDisposable[] b;
        MaybeDisposable<T>[] a;
        do {
            int n;
            if ((n = (a = this.observers.get()).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != inner) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new MaybeDisposable[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!this.observers.compareAndSet(a, b));
    }

    public T getValue() {
        if (this.observers.get() == TERMINATED) {
            return this.value;
        }
        return null;
    }

    public boolean hasValue() {
        return this.observers.get() == TERMINATED && this.value != null;
    }

    public Throwable getThrowable() {
        if (this.observers.get() == TERMINATED) {
            return this.error;
        }
        return null;
    }

    public boolean hasThrowable() {
        return this.observers.get() == TERMINATED && this.error != null;
    }

    public boolean hasComplete() {
        return this.observers.get() == TERMINATED && this.value == null && this.error == null;
    }

    public boolean hasObservers() {
        return this.observers.get().length != 0;
    }

    int observerCount() {
        return this.observers.get().length;
    }

    static final class MaybeDisposable<T>
    extends AtomicReference<MaybeSubject<T>>
    implements Disposable {
        private static final long serialVersionUID = -7650903191002190468L;
        final MaybeObserver<? super T> actual;

        MaybeDisposable(MaybeObserver<? super T> actual, MaybeSubject<T> parent) {
            this.actual = actual;
            this.lazySet(parent);
        }

        public void dispose() {
            MaybeSubject parent = this.getAndSet(null);
            if (parent != null) {
                parent.remove(this);
            }
        }

        public boolean isDisposed() {
            return this.get() == null;
        }
    }
}

