/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Nono;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.ErrorMode;
import io.reactivex.internal.util.HalfSerializer;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoConcat
extends Nono {
    final Publisher<? extends Nono> sources;
    final int prefetch;
    final ErrorMode errorMode;

    NonoConcat(Publisher<? extends Nono> sources, int prefetch, ErrorMode errorMode) {
        this.sources = sources;
        this.prefetch = prefetch;
        this.errorMode = errorMode;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        if (this.errorMode == ErrorMode.IMMEDIATE) {
            this.sources.subscribe((Subscriber)new ConcatImmediateSubscriber(s, this.prefetch));
        } else {
            this.sources.subscribe((Subscriber)new ConcatDelayedSubscriber(s, this.prefetch, this.errorMode == ErrorMode.END));
        }
    }

    static final class ConcatDelayedSubscriber
    extends AbstractConcatSubscriber {
        private static final long serialVersionUID = -3402839602492103389L;
        final boolean tillTheEnd;

        ConcatDelayedSubscriber(Subscriber<? super Void> actual, int prefetch, boolean tillTheEnd) {
            super(actual, prefetch);
            this.tillTheEnd = tillTheEnd;
        }

        public void onError(Throwable t) {
            if (this.error.addThrowable(t)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void cancel() {
            this.cancelled = true;
            this.s.cancel();
            this.inner.dispose();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            do {
                boolean empty;
                Nono np;
                if (this.cancelled) {
                    this.queue.clear();
                    return;
                }
                if (this.active) continue;
                if (!this.tillTheEnd && this.error.get() != null) {
                    this.queue.clear();
                    this.actual.onError(this.error.terminate());
                    return;
                }
                boolean d = this.done;
                try {
                    np = (Nono)this.queue.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.s.cancel();
                    this.queue.clear();
                    this.error.addThrowable(ex);
                    this.actual.onError(this.error.terminate());
                    return;
                }
                boolean bl = empty = np == null;
                if (d && empty) {
                    Throwable ex = this.error.terminate();
                    if (ex != null) {
                        this.actual.onError(ex);
                    } else {
                        this.actual.onComplete();
                    }
                    return;
                }
                if (empty) continue;
                this.requestOne();
                this.active = true;
                np.subscribe(this.inner);
            } while (this.decrementAndGet() != 0);
        }

        @Override
        void innerError(Throwable t) {
            if (this.error.addThrowable(t)) {
                if (!this.tillTheEnd) {
                    this.s.cancel();
                }
                this.active = false;
                this.drain();
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }
    }

    static final class ConcatImmediateSubscriber
    extends AbstractConcatSubscriber {
        private static final long serialVersionUID = 6000895759062406410L;
        final AtomicInteger wip = new AtomicInteger();

        ConcatImmediateSubscriber(Subscriber<? super Void> actual, int prefetch) {
            super(actual, prefetch);
        }

        public void onError(Throwable t) {
            this.cancel();
            HalfSerializer.onError((Subscriber)this.actual, (Throwable)t, (AtomicInteger)((Object)this), (AtomicThrowable)this.error);
        }

        @Override
        public void innerError(Throwable t) {
            this.cancel();
            HalfSerializer.onError((Subscriber)this.actual, (Throwable)t, (AtomicInteger)((Object)this), (AtomicThrowable)this.error);
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void cancel() {
            this.cancelled = true;
            this.s.cancel();
            this.inner.dispose();
            if (this.wip.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        @Override
        public void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            do {
                boolean empty;
                Nono np;
                if (this.cancelled) {
                    this.queue.clear();
                    return;
                }
                if (this.active) continue;
                boolean d = this.done;
                try {
                    np = (Nono)this.queue.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.s.cancel();
                    this.queue.clear();
                    HalfSerializer.onError((Subscriber)this.actual, (Throwable)ex, (AtomicInteger)((Object)this), (AtomicThrowable)this.error);
                    return;
                }
                boolean bl = empty = np == null;
                if (d && empty) {
                    HalfSerializer.onComplete((Subscriber)this.actual, (AtomicInteger)((Object)this), (AtomicThrowable)this.error);
                    return;
                }
                if (empty) continue;
                this.requestOne();
                this.active = true;
                np.subscribe(this.inner);
            } while (this.wip.decrementAndGet() != 0);
        }
    }

    static abstract class AbstractConcatSubscriber
    extends BasicIntQueueSubscription<Void>
    implements Subscriber<Nono> {
        private static final long serialVersionUID = -2273338080908719181L;
        final Subscriber<? super Void> actual;
        final int prefetch;
        final int limit;
        final AtomicThrowable error;
        final InnerSubscriber inner;
        Subscription s;
        SimpleQueue<Nono> queue;
        int sourceMode;
        int consumed;
        volatile boolean active;
        volatile boolean done;
        volatile boolean cancelled;

        AbstractConcatSubscriber(Subscriber<? super Void> actual, int prefetch) {
            this.actual = actual;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.error = new AtomicThrowable();
            this.inner = new InnerSubscriber();
        }

        public final void request(long n) {
        }

        public final int requestFusion(int mode) {
            return mode & 2;
        }

        public final void clear() {
        }

        public final Void poll() throws Exception {
            return null;
        }

        public final boolean isEmpty() {
            return true;
        }

        public final void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.actual.onSubscribe((Subscription)this);
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.actual.onSubscribe((Subscription)this);
                        s.request(this.prefetch == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.prefetch);
                        return;
                    }
                }
                if (this.prefetch == Integer.MAX_VALUE) {
                    this.queue = new SpscLinkedArrayQueue(Nono.bufferSize());
                    this.actual.onSubscribe((Subscription)this);
                    s.request(Long.MAX_VALUE);
                } else {
                    this.queue = new SpscArrayQueue(this.prefetch);
                    this.actual.onSubscribe((Subscription)this);
                    s.request((long)this.prefetch);
                }
            }
        }

        final void requestOne() {
            if (this.sourceMode != 1 && this.prefetch != Integer.MAX_VALUE) {
                int c = this.consumed + 1;
                if (c == this.limit) {
                    this.consumed = 0;
                    this.s.request((long)c);
                } else {
                    this.consumed = c;
                }
            }
        }

        public final void onNext(Nono t) {
            if (this.sourceMode == 0 && !this.queue.offer((Object)t)) {
                this.s.cancel();
                this.onError((Throwable)new MissingBackpressureException());
                return;
            }
            this.drain();
        }

        final void innerComplete() {
            this.active = false;
            this.drain();
        }

        abstract void drain();

        abstract void innerError(Throwable var1);

        final class InnerSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<Void> {
            private static final long serialVersionUID = -1235060320533681511L;

            InnerSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                SubscriptionHelper.replace((AtomicReference)this, (Subscription)s);
            }

            public void onNext(Void t) {
            }

            public void onError(Throwable t) {
                AbstractConcatSubscriber.this.innerError(t);
            }

            public void onComplete() {
                AbstractConcatSubscriber.this.active = false;
                AbstractConcatSubscriber.this.drain();
            }

            void dispose() {
                SubscriptionHelper.cancel((AtomicReference)this);
            }
        }
    }
}

