/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Perhaps;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class PerhapsFlatMap<T, R>
extends Perhaps<R> {
    final Perhaps<T> source;
    final Function<? super T, ? extends Perhaps<? extends R>> mapper;

    PerhapsFlatMap(Perhaps<T> source, Function<? super T, ? extends Perhaps<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new FlatMapSubscriber<T, R>(s, this.mapper));
    }

    static final class FlatMapSubscriber<T, R>
    extends DeferredScalarSubscription<R>
    implements Subscriber<T> {
        private static final long serialVersionUID = 1417117475410404413L;
        final Function<? super T, ? extends Perhaps<? extends R>> mapper;
        final InnerSubscriber inner;
        Subscription s;
        boolean hasValue;

        FlatMapSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends Perhaps<? extends R>> mapper) {
            super(actual);
            this.mapper = mapper;
            this.inner = new InnerSubscriber();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            Perhaps ph;
            this.hasValue = true;
            try {
                ph = (Perhaps)ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper returned a null Perhaps");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.actual.onError(ex);
                return;
            }
            ph.subscribe(this.inner);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            if (!this.hasValue) {
                this.actual.onComplete();
            }
        }

        void innerNext(R t) {
            this.value = t;
        }

        void innerError(Throwable ex) {
            this.actual.onError(ex);
        }

        void innerComplete() {
            Object v = this.value;
            if (v != null) {
                this.complete(v);
            } else {
                this.actual.onComplete();
            }
        }

        public void cancel() {
            super.cancel();
            this.s.cancel();
            SubscriptionHelper.cancel((AtomicReference)this.inner);
        }

        final class InnerSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<R> {
            private static final long serialVersionUID = -7349825169192389387L;

            InnerSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(R t) {
                FlatMapSubscriber.this.innerNext(t);
            }

            public void onError(Throwable t) {
                FlatMapSubscriber.this.innerError(t);
            }

            public void onComplete() {
                FlatMapSubscriber.this.innerComplete();
            }
        }
    }
}

