/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.debug.validator;

import hu.akarnokd.rxjava2.debug.validator.MultipleOnSubscribeCallsException;
import hu.akarnokd.rxjava2.debug.validator.MultipleTerminationsException;
import hu.akarnokd.rxjava2.debug.validator.NullOnErrorParameterException;
import hu.akarnokd.rxjava2.debug.validator.NullOnNextParameterException;
import hu.akarnokd.rxjava2.debug.validator.NullOnSubscribeParameterException;
import hu.akarnokd.rxjava2.debug.validator.OnNextAfterTerminationException;
import hu.akarnokd.rxjava2.debug.validator.OnSubscribeNotCalledException;
import hu.akarnokd.rxjava2.debug.validator.ProtocolNonConformanceException;
import hu.akarnokd.rxjava2.functions.PlainConsumer;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

final class ObservableValidator<T>
extends Observable<T> {
    final Observable<T> source;
    final PlainConsumer<ProtocolNonConformanceException> onViolation;

    ObservableValidator(Observable<T> source, PlainConsumer<ProtocolNonConformanceException> onViolation) {
        this.source = source;
        this.onViolation = onViolation;
    }

    protected void subscribeActual(Observer<? super T> s) {
        this.source.subscribe(new ValidatorConsumer<T>(s, this.onViolation));
    }

    static final class ValidatorConsumer<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> actual;
        final PlainConsumer<ProtocolNonConformanceException> onViolation;
        Disposable upstream;
        boolean done;

        ValidatorConsumer(Observer<? super T> actual, PlainConsumer<ProtocolNonConformanceException> onViolation) {
            this.actual = actual;
            this.onViolation = onViolation;
        }

        public void onSubscribe(Disposable d) {
            Disposable u;
            if (d == null) {
                this.onViolation.accept(new NullOnSubscribeParameterException());
            }
            if ((u = this.upstream) != null) {
                this.onViolation.accept(new MultipleOnSubscribeCallsException());
            }
            this.upstream = d;
            this.actual.onSubscribe((Disposable)this);
        }

        public void onNext(T t) {
            if (t == null) {
                this.onViolation.accept(new NullOnNextParameterException());
            }
            if (this.upstream == null) {
                this.onViolation.accept(new OnSubscribeNotCalledException());
            }
            if (this.done) {
                this.onViolation.accept(new OnNextAfterTerminationException());
            } else {
                this.actual.onNext(t);
            }
        }

        public void onError(Throwable e) {
            if (e == null) {
                this.onViolation.accept(new NullOnErrorParameterException());
            }
            if (this.upstream == null) {
                this.onViolation.accept(new OnSubscribeNotCalledException(e));
            }
            if (this.done) {
                this.onViolation.accept(new MultipleTerminationsException(e));
            } else {
                this.done = true;
                this.actual.onError(e);
            }
        }

        public void onComplete() {
            if (this.upstream == null) {
                OnSubscribeNotCalledException ex = new OnSubscribeNotCalledException();
                this.onViolation.accept(ex);
            }
            if (this.done) {
                this.onViolation.accept(new MultipleTerminationsException());
            } else {
                this.done = true;
                this.actual.onComplete();
            }
        }

        public void dispose() {
            this.upstream.dispose();
        }

        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }
    }
}

