/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Scheduler;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableZipLatest<T, R>
extends Flowable<R> {
    final Publisher<? extends T>[] sources;
    final Iterable<? extends Publisher<? extends T>> sourcesIterable;
    final Function<? super Object[], ? extends R> combiner;
    final Scheduler scheduler;

    FlowableZipLatest(Publisher<? extends T>[] sources, Iterable<? extends Publisher<? extends T>> sourcesIterable, Function<? super Object[], ? extends R> combiner, Scheduler scheduler) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
        this.combiner = combiner;
        this.scheduler = scheduler;
    }

    protected void subscribeActual(Subscriber<? super R> s) {
        int n;
        Publisher<? extends T>[] srcs = this.sources;
        if (srcs == null) {
            srcs = new Publisher[8];
            n = 0;
            for (Publisher<? extends T> publisher : this.sourcesIterable) {
                if (n == srcs.length) {
                    srcs = Arrays.copyOf(srcs, n + (n >> 1));
                }
                srcs[n++] = publisher;
            }
        } else {
            n = srcs.length;
        }
        if (n == 0) {
            Flowable.empty().observeOn(this.scheduler).subscribe(s);
        } else {
            ZipLatestCoordinator<? extends T, R> zc = new ZipLatestCoordinator<T, R>(s, n, this.scheduler.createWorker(), this.combiner);
            s.onSubscribe(zc);
            zc.subscribe(srcs, n);
        }
    }

    static final class ZipLatestCoordinator<T, R>
    extends AtomicReferenceArray<T>
    implements Subscription,
    Runnable {
        private static final long serialVersionUID = -8321911708267957704L;
        final Subscriber<? super R> actual;
        final InnerSubscriber<T>[] subscribers;
        final AtomicInteger wip;
        final AtomicLong requested;
        final Scheduler.Worker worker;
        final AtomicThrowable errors;
        final Function<? super Object[], ? extends R> combiner;
        volatile boolean cancelled;
        long emitted;

        ZipLatestCoordinator(Subscriber<? super R> actual, int n, Scheduler.Worker worker, Function<? super Object[], ? extends R> combiner) {
            super(n);
            this.actual = actual;
            this.subscribers = new InnerSubscriber[n];
            this.wip = new AtomicInteger();
            this.requested = new AtomicLong();
            this.errors = new AtomicThrowable();
            this.worker = worker;
            for (int i = 0; i < n; ++i) {
                this.subscribers[i] = new InnerSubscriber(this, i);
            }
            this.combiner = combiner;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.drain();
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.cancelAll();
            if (this.wip.getAndIncrement() == 0) {
                this.clear();
            }
        }

        void cancelAll() {
            for (InnerSubscriber<T> inner : this.subscribers) {
                inner.cancel();
            }
        }

        void clear() {
            int n = this.length();
            for (int i = 0; i < n; ++i) {
                this.lazySet(i, null);
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() == 0) {
                this.worker.schedule((Runnable)this);
            }
        }

        @Override
        public void run() {
            int missed = 1;
            long e = this.emitted;
            InnerSubscriber<T>[] subs = this.subscribers;
            int n = subs.length;
            Subscriber<? super R> a = this.actual;
            do {
                long r = this.requested.get();
                while (e != r) {
                    Object v;
                    if (this.cancelled) {
                        this.clear();
                        return;
                    }
                    boolean someEmpty = false;
                    for (int i = 0; i < n; ++i) {
                        boolean d = subs[i].done;
                        Object o = this.get(i);
                        if (d && o == null) {
                            this.cancelled = true;
                            this.cancelAll();
                            this.clear();
                            Throwable ex = this.errors.terminate();
                            if (ex == null) {
                                a.onComplete();
                            } else {
                                a.onError(ex);
                            }
                            this.worker.dispose();
                            return;
                        }
                        if (o != null) continue;
                        someEmpty = true;
                    }
                    if (someEmpty) break;
                    Object[] array = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        array[i] = this.getAndSet(i, null);
                    }
                    try {
                        v = ObjectHelper.requireNonNull((Object)this.combiner.apply((Object)array), (String)"The combiner returned a null value");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        this.errors.addThrowable(ex);
                        this.cancelled = true;
                        this.cancelAll();
                        this.clear();
                        a.onError(this.errors.terminate());
                        this.worker.dispose();
                        return;
                    }
                    a.onNext(v);
                    ++e;
                }
                if (e == r) {
                    if (this.cancelled) {
                        this.clear();
                        return;
                    }
                    for (int i = 0; i < n; ++i) {
                        if (!subs[i].done || this.get(i) != null) continue;
                        this.cancelled = true;
                        this.cancelAll();
                        this.clear();
                        Throwable ex = this.errors.terminate();
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        this.worker.dispose();
                        return;
                    }
                }
                this.emitted = e;
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        void subscribe(Publisher<? extends T>[] sources, int n) {
            for (int i = 0; i < n; ++i) {
                if (this.cancelled) {
                    return;
                }
                sources[i].subscribe(this.subscribers[i]);
            }
        }

        static final class InnerSubscriber<T>
        extends AtomicReference<Subscription>
        implements FlowableSubscriber<T> {
            private static final long serialVersionUID = -5384962852497888461L;
            final ZipLatestCoordinator<T, ?> parent;
            final int index;
            volatile boolean done;

            InnerSubscriber(ZipLatestCoordinator<T, ?> parent, int index) {
                this.index = index;
                this.parent = parent;
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(T t) {
                ZipLatestCoordinator<T, ?> p = this.parent;
                p.lazySet(this.index, t);
                p.drain();
            }

            public void onError(Throwable t) {
                ZipLatestCoordinator<T, ?> p = this.parent;
                if (p.errors.addThrowable(t)) {
                    this.lazySet(SubscriptionHelper.CANCELLED);
                    this.done = true;
                    p.drain();
                } else {
                    RxJavaPlugins.onError((Throwable)t);
                }
            }

            public void onComplete() {
                this.lazySet(SubscriptionHelper.CANCELLED);
                this.done = true;
                this.parent.drain();
            }

            void cancel() {
                SubscriptionHelper.cancel((AtomicReference)this);
            }
        }
    }
}

