/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.processors;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.subjects.Subject;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

final class RefCountSubject<T>
extends Subject<T>
implements Disposable {
    final Subject<T> actual;
    final AtomicReference<Disposable> upstream;
    final AtomicReference<RefCountObserver<T>[]> observers;
    static final RefCountObserver[] EMPTY = new RefCountObserver[0];
    static final RefCountObserver[] TERMINATED = new RefCountObserver[0];

    RefCountSubject(Subject<T> actual) {
        this.actual = actual;
        this.upstream = new AtomicReference();
        this.observers = new AtomicReference<RefCountObserver[]>(EMPTY);
    }

    public void onSubscribe(Disposable s) {
        if (DisposableHelper.setOnce(this.upstream, (Disposable)s)) {
            this.actual.onSubscribe((Disposable)this);
        }
    }

    public void onNext(T t) {
        this.actual.onNext(t);
    }

    public void onError(Throwable t) {
        this.upstream.lazySet((Disposable)DisposableHelper.DISPOSED);
        this.actual.onError(t);
    }

    public void onComplete() {
        this.upstream.lazySet((Disposable)DisposableHelper.DISPOSED);
        this.actual.onComplete();
    }

    protected void subscribeActual(Observer<? super T> s) {
        RefCountObserver<? super T> rcs = new RefCountObserver<T>(s, this);
        if (!this.add(rcs)) {
            EmptyDisposable.error((Throwable)new IllegalStateException("RefCountSubject terminated"), s);
            return;
        }
        this.actual.subscribe(rcs);
    }

    public boolean hasComplete() {
        return this.actual.hasComplete();
    }

    public boolean hasThrowable() {
        return this.actual.hasThrowable();
    }

    public Throwable getThrowable() {
        return this.actual.getThrowable();
    }

    public boolean hasObservers() {
        return this.actual.hasObservers();
    }

    public void dispose() {
        DisposableHelper.dispose(this.upstream);
    }

    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.upstream.get());
    }

    boolean add(RefCountObserver<T> rcs) {
        RefCountObserver[] b;
        RefCountObserver<T>[] a;
        do {
            if ((a = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new RefCountObserver[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = rcs;
        } while (!this.observers.compareAndSet(a, b));
        return true;
    }

    void remove(RefCountObserver<T> rcs) {
        RefCountObserver<T>[] a;
        int n;
        while ((n = (a = this.observers.get()).length) != 0) {
            RefCountObserver[] b;
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (rcs != a[i]) continue;
                j = i;
                break;
            }
            if (j < 0) break;
            if (n == 1) {
                b = TERMINATED;
            } else {
                b = new RefCountObserver[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            }
            if (!this.observers.compareAndSet(a, b)) continue;
            if (b != TERMINATED) break;
            this.dispose();
            break;
        }
    }

    static final class RefCountObserver<T>
    extends AtomicBoolean
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -4317488092687530631L;
        final Observer<? super T> actual;
        final RefCountSubject<T> parent;
        Disposable upstream;

        RefCountObserver(Observer<? super T> actual, RefCountSubject<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        public void dispose() {
            this.lazySet(true);
            this.upstream.dispose();
            this.parent.remove(this);
        }

        public void onSubscribe(Disposable s) {
            this.upstream = s;
            this.actual.onSubscribe((Disposable)this);
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }
    }
}

