/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.math;

import hu.akarnokd.rxjava2.math.FlowableAverageDouble;
import hu.akarnokd.rxjava2.math.FlowableAverageFloat;
import hu.akarnokd.rxjava2.math.FlowableMinMax;
import hu.akarnokd.rxjava2.math.FlowableSumDouble;
import hu.akarnokd.rxjava2.math.FlowableSumFloat;
import hu.akarnokd.rxjava2.math.FlowableSumInt;
import hu.akarnokd.rxjava2.math.FlowableSumLong;
import hu.akarnokd.rxjava2.util.SelfComparator;
import io.reactivex.Flowable;
import java.util.Comparator;
import org.reactivestreams.Publisher;

public final class MathFlowable {
    private MathFlowable() {
        throw new IllegalStateException("No instances!");
    }

    public static Flowable<Integer> sumInt(Publisher<Integer> source) {
        return new FlowableSumInt(source);
    }

    public static Flowable<Long> sumLong(Publisher<Long> source) {
        return new FlowableSumLong(source);
    }

    public static Flowable<Float> sumFloat(Publisher<Float> source) {
        return new FlowableSumFloat(source);
    }

    public static Flowable<Double> sumDouble(Publisher<Double> source) {
        return new FlowableSumDouble(source);
    }

    public static <T extends Comparable<? super T>> Flowable<T> max(Publisher<T> source) {
        Comparator comp = SelfComparator.instance();
        return MathFlowable.max(source, comp);
    }

    public static <T> Flowable<T> max(Publisher<T> source, Comparator<? super T> comparator) {
        return new FlowableMinMax<T>(source, comparator, -1);
    }

    public static <T extends Comparable<? super T>> Flowable<T> min(Publisher<T> source) {
        Comparator comp = SelfComparator.instance();
        return MathFlowable.min(source, comp);
    }

    public static <T> Flowable<T> min(Publisher<T> source, Comparator<? super T> comparator) {
        return new FlowableMinMax<T>(source, comparator, 1);
    }

    public static Flowable<Float> averageFloat(Publisher<? extends Number> source) {
        return new FlowableAverageFloat((Publisher<Number>)source);
    }

    public static Flowable<Double> averageDouble(Publisher<? extends Number> source) {
        return new FlowableAverageDouble((Publisher<Number>)source);
    }
}

