/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.math;

import hu.akarnokd.rxjava2.math.ObservableWithSource;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.internal.subscribers.observable.DeferredScalarObserver;

public class ObservableAverageDouble
extends ObservableWithSource<Number, Double> {
    public ObservableAverageDouble(ObservableSource<Number> source) {
        super(source);
    }

    protected void subscribeActual(Observer<? super Double> observer) {
        this.source.subscribe((Observer)new AverageDoubleObserver(observer));
    }

    static final class AverageDoubleObserver
    extends DeferredScalarObserver<Number, Double> {
        private static final long serialVersionUID = 6990557227019180008L;
        double accumulator;
        long count;

        public AverageDoubleObserver(Observer<? super Double> actual) {
            super(actual);
        }

        public void onNext(Number value) {
            ++this.count;
            this.accumulator += value.doubleValue();
        }

        public void onComplete() {
            long c = this.count;
            if (c != 0L) {
                this.complete(this.accumulator / (double)c);
            } else {
                this.actual.onComplete();
            }
        }
    }
}

