/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.parallel;

import hu.akarnokd.rxjava2.parallel.ParallelFlowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiConsumer;
import io.reactivex.internal.subscribers.flowable.DeferredScalarSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class ParallelCollect<T, C>
extends ParallelFlowable<C> {
    final ParallelFlowable<? extends T> source;
    final Callable<C> initialCollection;
    final BiConsumer<C, T> collector;

    public ParallelCollect(ParallelFlowable<? extends T> source, Callable<C> initialCollection, BiConsumer<C, T> collector) {
        this.source = source;
        this.initialCollection = initialCollection;
        this.collector = collector;
    }

    @Override
    public void subscribe(Subscriber<? super C>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            C initialValue;
            try {
                initialValue = this.initialCollection.call();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.reportError(subscribers, ex);
                return;
            }
            if (initialValue == null) {
                this.reportError(subscribers, new NullPointerException("The initialSupplier returned a null value"));
                return;
            }
            parents[i] = new ParallelCollectSubscriber<T, C>(subscribers[i], initialValue, this.collector);
        }
        this.source.subscribe(parents);
    }

    void reportError(Subscriber<?>[] subscribers, Throwable ex) {
        for (Subscriber<?> s : subscribers) {
            EmptySubscription.error((Throwable)ex, s);
        }
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelCollectSubscriber<T, C>
    extends DeferredScalarSubscriber<T, C> {
        private static final long serialVersionUID = -4767392946044436228L;
        final BiConsumer<C, T> collector;
        C collection;
        boolean done;

        public ParallelCollectSubscriber(Subscriber<? super C> subscriber, C initialValue, BiConsumer<C, T> collector) {
            super(subscriber);
            this.collection = initialValue;
            this.collector = collector;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            try {
                this.collector.accept(this.collection, t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.cancel();
                this.onError(ex);
                return;
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.collection = null;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            C c = this.collection;
            this.collection = null;
            this.complete(c);
        }

        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

