/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.parallel;

import hu.akarnokd.rxjava2.parallel.ParallelFlowable;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableConcatMap;
import io.reactivex.internal.util.ErrorMode;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class ParallelConcatMap<T, R>
extends ParallelFlowable<R> {
    final ParallelFlowable<T> source;
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int prefetch;
    final ErrorMode errorMode;

    public ParallelConcatMap(ParallelFlowable<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
        this.source = source;
        this.mapper = (Function)ObjectHelper.requireNonNull(mapper, (String)"mapper");
        this.prefetch = prefetch;
        this.errorMode = (ErrorMode)ObjectHelper.requireNonNull((Object)errorMode, (String)"errorMode");
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        final Subscriber[] parents = new Subscriber[n];
        Publisher p = new Publisher<T>(){
            int i;

            public void subscribe(Subscriber<? super T> s) {
                parents[this.i++] = s;
            }
        };
        FlowableConcatMap op = new FlowableConcatMap(p, this.mapper, this.prefetch, this.errorMode);
        for (int i = 0; i < n; ++i) {
            op.subscribe(subscribers[i]);
        }
        this.source.subscribe(parents);
    }
}

