/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.parallel;

import hu.akarnokd.rxjava2.parallel.ParallelFlowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class ParallelFilter<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<T> source;
    final Predicate<? super T> predicate;

    public ParallelFilter(ParallelFlowable<T> source, Predicate<? super T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            parents[i] = new ParallelFilterSubscriber<T>(subscribers[i], this.predicate);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelFilterSubscriber<T>
    implements Subscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        final Predicate<? super T> predicate;
        Subscription s;
        boolean done;

        public ParallelFilterSubscriber(Subscriber<? super T> actual, Predicate<? super T> predicate) {
            this.actual = actual;
            this.predicate = predicate;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            boolean b;
            if (this.done) {
                return;
            }
            try {
                b = this.predicate.test(t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.cancel();
                this.onError(ex);
                return;
            }
            if (b) {
                this.actual.onNext(t);
            } else {
                this.s.request(1L);
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }
    }
}

