/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.parallel;

import hu.akarnokd.rxjava2.parallel.ParallelFlowable;
import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class ParallelJoin<T>
extends Flowable<T> {
    final ParallelFlowable<? extends T> source;
    final int prefetch;

    public ParallelJoin(ParallelFlowable<? extends T> source, int prefetch) {
        this.source = source;
        this.prefetch = prefetch;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        JoinSubscription<? super T> parent = new JoinSubscription<T>(s, this.source.parallelism(), this.prefetch);
        s.onSubscribe(parent);
        this.source.subscribe(parent.subscribers);
    }

    static final class JoinInnerSubscriber<T>
    extends AtomicReference<Subscription>
    implements Subscriber<T> {
        private static final long serialVersionUID = 8410034718427740355L;
        final JoinSubscription<T> parent;
        final int prefetch;
        final int limit;
        long produced;
        volatile SimpleQueue<T> queue;
        volatile boolean done;

        public JoinInnerSubscriber(JoinSubscription<T> parent, int prefetch) {
            this.parent = parent;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                s.request((long)this.prefetch);
            }
        }

        public void onNext(T t) {
            this.parent.onNext(this, t);
        }

        public void onError(Throwable t) {
            this.parent.onError(t);
        }

        public void onComplete() {
            this.parent.onComplete();
        }

        public void requestOne() {
            long p = this.produced + 1L;
            if (p == (long)this.limit) {
                this.produced = 0L;
                ((Subscription)this.get()).request(p);
            } else {
                this.produced = p;
            }
        }

        public void request(long n) {
            long p = this.produced + n;
            if (p >= (long)this.limit) {
                this.produced = 0L;
                ((Subscription)this.get()).request(p);
            } else {
                this.produced = p;
            }
        }

        public void cancel() {
            SubscriptionHelper.cancel((AtomicReference)this);
        }

        SimpleQueue<T> getQueue() {
            SpscArrayQueue q = this.queue;
            if (q == null) {
                this.queue = q = new SpscArrayQueue(this.prefetch);
            }
            return q;
        }
    }

    static final class JoinSubscription<T>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = 3100232009247827843L;
        final Subscriber<? super T> actual;
        final JoinInnerSubscriber<T>[] subscribers;
        final AtomicThrowable error = new AtomicThrowable();
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        final AtomicInteger done = new AtomicInteger();

        public JoinSubscription(Subscriber<? super T> actual, int n, int prefetch) {
            this.actual = actual;
            JoinInnerSubscriber[] a = new JoinInnerSubscriber[n];
            for (int i = 0; i < n; ++i) {
                a[i] = new JoinInnerSubscriber(this, prefetch);
            }
            this.subscribers = a;
            this.done.lazySet(n);
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
                if (this.getAndIncrement() == 0) {
                    this.cleanup();
                }
            }
        }

        void cancelAll() {
            for (JoinInnerSubscriber<T> s : this.subscribers) {
                s.cancel();
            }
        }

        void cleanup() {
            for (JoinInnerSubscriber<T> s : this.subscribers) {
                s.queue = null;
            }
        }

        void onNext(JoinInnerSubscriber<T> inner, T value) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                if (this.requested.get() != 0L) {
                    this.actual.onNext(value);
                    if (this.requested.get() != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                    inner.request(1L);
                } else {
                    SimpleQueue<T> q = inner.getQueue();
                    q.offer(value);
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimpleQueue<T> q = inner.getQueue();
                q.offer(value);
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        void onError(Throwable e) {
            if (this.error.addThrowable(e)) {
                this.cancelAll();
                this.drain();
            } else {
                RxJavaPlugins.onError((Throwable)e);
            }
        }

        void onComplete() {
            this.done.decrementAndGet();
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            this.drainLoop();
        }

        void drainLoop() {
            int missed = 1;
            JoinInnerSubscriber<T>[] s = this.subscribers;
            int n = s.length;
            Subscriber<? super T> a = this.actual;
            while (true) {
                int w;
                SimpleQueue q;
                JoinInnerSubscriber<T> inner;
                int i;
                boolean empty;
                boolean d;
                Throwable ex;
                long r = this.requested.get();
                long e = 0L;
                block3: while (e != r) {
                    if (this.cancelled) {
                        this.cleanup();
                        return;
                    }
                    ex = (Throwable)this.error.get();
                    if (ex != null) {
                        this.cleanup();
                        a.onError(this.error.terminate());
                        return;
                    }
                    d = this.done.get() == 0;
                    empty = true;
                    for (i = 0; i < n; ++i) {
                        Object v;
                        inner = s[i];
                        q = inner.queue;
                        if (q == null) continue;
                        try {
                            v = q.poll();
                        }
                        catch (Throwable exc) {
                            Exceptions.throwIfFatal((Throwable)exc);
                            this.error.addThrowable(exc);
                            this.cancelAll();
                            this.actual.onError(this.error.terminate());
                            return;
                        }
                        if (v == null) continue;
                        empty = false;
                        a.onNext(v);
                        inner.requestOne();
                        if (++e == r) break block3;
                    }
                    if (d && empty) {
                        a.onComplete();
                        return;
                    }
                    if (!empty) continue;
                    break;
                }
                if (e == r) {
                    if (this.cancelled) {
                        this.cleanup();
                        return;
                    }
                    ex = (Throwable)this.error.get();
                    if (ex != null) {
                        this.cleanup();
                        a.onError(this.error.terminate());
                        return;
                    }
                    d = this.done.get() == 0;
                    empty = true;
                    for (i = 0; i < n; ++i) {
                        inner = s[i];
                        q = inner.queue;
                        if (q == null || q.isEmpty()) continue;
                        empty = false;
                        break;
                    }
                    if (d && empty) {
                        a.onComplete();
                        return;
                    }
                }
                if (e != 0L && r != Long.MAX_VALUE) {
                    this.requested.addAndGet(-e);
                }
                if ((w = this.get()) == missed) {
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }
    }
}

