/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.parallel;

import hu.akarnokd.rxjava2.parallel.ParallelFlowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.subscribers.flowable.DeferredScalarSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class ParallelReduce<T, R>
extends ParallelFlowable<R> {
    final ParallelFlowable<? extends T> source;
    final Callable<R> initialSupplier;
    final BiFunction<R, T, R> reducer;

    public ParallelReduce(ParallelFlowable<? extends T> source, Callable<R> initialSupplier, BiFunction<R, T, R> reducer) {
        this.source = source;
        this.initialSupplier = initialSupplier;
        this.reducer = reducer;
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            R initialValue;
            try {
                initialValue = this.initialSupplier.call();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.reportError(subscribers, ex);
                return;
            }
            if (initialValue == null) {
                this.reportError(subscribers, new NullPointerException("The initialSupplier returned a null value"));
                return;
            }
            parents[i] = new ParallelReduceSubscriber<T, R>(subscribers[i], initialValue, this.reducer);
        }
        this.source.subscribe(parents);
    }

    void reportError(Subscriber<?>[] subscribers, Throwable ex) {
        for (Subscriber<?> s : subscribers) {
            EmptySubscription.error((Throwable)ex, s);
        }
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelReduceSubscriber<T, R>
    extends DeferredScalarSubscriber<T, R> {
        private static final long serialVersionUID = 8200530050639449080L;
        final BiFunction<R, T, R> reducer;
        R accumulator;
        boolean done;

        public ParallelReduceSubscriber(Subscriber<? super R> subscriber, R initialValue, BiFunction<R, T, R> reducer) {
            super(subscriber);
            this.accumulator = initialValue;
            this.reducer = reducer;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            Object v;
            if (this.done) {
                return;
            }
            try {
                v = this.reducer.apply(this.accumulator, t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.cancel();
                this.onError(ex);
                return;
            }
            if (v == null) {
                this.cancel();
                this.onError(new NullPointerException("The reducer returned a null value"));
                return;
            }
            this.accumulator = v;
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.accumulator = null;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            R a = this.accumulator;
            this.accumulator = null;
            this.complete(a);
        }

        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

