/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.parallel;

import hu.akarnokd.rxjava2.parallel.ParallelFlowable;
import io.reactivex.Scheduler;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class ParallelRunOn<T>
extends ParallelFlowable<T> {
    final ParallelFlowable<? extends T> source;
    final Scheduler scheduler;
    final int prefetch;

    public ParallelRunOn(ParallelFlowable<? extends T> parent, Scheduler scheduler, int prefetch) {
        this.source = parent;
        this.scheduler = scheduler;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        int prefetch = this.prefetch;
        for (int i = 0; i < n; ++i) {
            RunOnSubscriber<? super T> parent;
            Subscriber<? super T> a = subscribers[i];
            Scheduler.Worker w = this.scheduler.createWorker();
            SpscArrayQueue q = new SpscArrayQueue(prefetch);
            parents[i] = parent = new RunOnSubscriber<T>(a, prefetch, q, w);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class RunOnSubscriber<T>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 1075119423897941642L;
        final Subscriber<? super T> actual;
        final int prefetch;
        final int limit;
        final SpscArrayQueue<T> queue;
        final Scheduler.Worker worker;
        Subscription s;
        volatile boolean done;
        Throwable error;
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        int consumed;

        public RunOnSubscriber(Subscriber<? super T> actual, int prefetch, SpscArrayQueue<T> queue, Scheduler.Worker worker) {
            this.actual = actual;
            this.prefetch = prefetch;
            this.queue = queue;
            this.limit = prefetch - (prefetch >> 2);
            this.worker = worker;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request((long)this.prefetch);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (!this.queue.offer(t)) {
                this.onError(new IllegalStateException("Queue is full?!"));
                return;
            }
            this.schedule();
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
                return;
            }
            this.error = t;
            this.done = true;
            this.schedule();
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.schedule();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.schedule();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                this.worker.dispose();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        void schedule() {
            if (this.getAndIncrement() == 0) {
                this.worker.schedule((Runnable)this);
            }
        }

        @Override
        public void run() {
            int missed = 1;
            int c = this.consumed;
            SpscArrayQueue<T> q = this.queue;
            Subscriber<? super T> a = this.actual;
            int lim = this.limit;
            while (true) {
                int w;
                long e;
                long r = this.requested.get();
                for (e = 0L; e != r; ++e) {
                    int p;
                    boolean empty;
                    Throwable ex;
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    boolean d = this.done;
                    if (d && (ex = this.error) != null) {
                        q.clear();
                        a.onError(ex);
                        this.worker.dispose();
                        return;
                    }
                    Object v = q.poll();
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        a.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    if (empty) break;
                    a.onNext(v);
                    if ((p = ++c) != lim) continue;
                    c = 0;
                    this.s.request((long)p);
                }
                if (e == r) {
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    if (this.done) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            q.clear();
                            a.onError(ex);
                            this.worker.dispose();
                            return;
                        }
                        if (q.isEmpty()) {
                            a.onComplete();
                            this.worker.dispose();
                            return;
                        }
                    }
                }
                if (e != 0L && r != Long.MAX_VALUE) {
                    this.requested.addAndGet(-e);
                }
                if ((w = this.get()) == missed) {
                    this.consumed = c;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }
    }
}

