/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.parallel;

import hu.akarnokd.rxjava2.parallel.ParallelFlowable;
import io.reactivex.Flowable;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class ParallelSortedJoin<T>
extends Flowable<T> {
    final ParallelFlowable<List<T>> source;
    final Comparator<? super T> comparator;

    public ParallelSortedJoin(ParallelFlowable<List<T>> source, Comparator<? super T> comparator) {
        this.source = source;
        this.comparator = comparator;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        SortedJoinSubscription<? super T> parent = new SortedJoinSubscription<T>(s, this.source.parallelism(), this.comparator);
        s.onSubscribe(parent);
        this.source.subscribe(parent.subscribers);
    }

    static final class SortedJoinInnerSubscriber<T>
    extends AtomicReference<Subscription>
    implements Subscriber<List<T>> {
        private static final long serialVersionUID = 6751017204873808094L;
        final SortedJoinSubscription<T> parent;
        final int index;

        public SortedJoinInnerSubscriber(SortedJoinSubscription<T> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(List<T> t) {
            this.parent.innerNext(t, this.index);
        }

        public void onError(Throwable t) {
            this.parent.innerError(t);
        }

        public void onComplete() {
        }

        void cancel() {
            SubscriptionHelper.cancel((AtomicReference)this);
        }
    }

    static final class SortedJoinSubscription<T>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = 3481980673745556697L;
        final Subscriber<? super T> actual;
        final SortedJoinInnerSubscriber<T>[] subscribers;
        final List<T>[] lists;
        final int[] indexes;
        final Comparator<? super T> comparator;
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        final AtomicInteger remaining = new AtomicInteger();
        final AtomicThrowable error = new AtomicThrowable();

        public SortedJoinSubscription(Subscriber<? super T> actual, int n, Comparator<? super T> comparator) {
            this.actual = actual;
            this.comparator = comparator;
            SortedJoinInnerSubscriber[] s = new SortedJoinInnerSubscriber[n];
            for (int i = 0; i < n; ++i) {
                s[i] = new SortedJoinInnerSubscriber(this, i);
            }
            this.subscribers = s;
            this.lists = new List[n];
            this.indexes = new int[n];
            this.remaining.lazySet(n);
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                if (this.remaining.get() == 0) {
                    this.drain();
                }
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
                if (this.getAndIncrement() == 0) {
                    Arrays.fill(this.lists, null);
                }
            }
        }

        void cancelAll() {
            for (SortedJoinInnerSubscriber<T> s : this.subscribers) {
                s.cancel();
            }
        }

        void innerNext(List<T> value, int index) {
            this.lists[index] = value;
            if (this.remaining.decrementAndGet() == 0) {
                this.drain();
            }
        }

        void innerError(Throwable e) {
            if (this.error.addThrowable(e)) {
                this.drain();
            } else {
                RxJavaPlugins.onError((Throwable)e);
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<? super T> a = this.actual;
            Object[] lists = this.lists;
            int[] indexes = this.indexes;
            int n = indexes.length;
            while (true) {
                int w;
                Throwable ex;
                long e;
                long r = this.requested.get();
                for (e = 0L; e != r; ++e) {
                    if (this.cancelled) {
                        Arrays.fill(lists, null);
                        return;
                    }
                    ex = (Throwable)this.error.get();
                    if (ex != null) {
                        this.cancelAll();
                        Arrays.fill(lists, null);
                        a.onError(this.error.terminate());
                        return;
                    }
                    Object min = null;
                    int minIndex = -1;
                    for (int i = 0; i < n; ++i) {
                        Object list = lists[i];
                        int index = indexes[i];
                        if (list.size() == index) continue;
                        if (min == null) {
                            min = list.get(index);
                            minIndex = i;
                            continue;
                        }
                        Object b = list.get(index);
                        if (this.comparator.compare(min, b) <= 0) continue;
                        min = b;
                        minIndex = i;
                    }
                    if (min == null) {
                        Arrays.fill(lists, null);
                        a.onComplete();
                        return;
                    }
                    a.onNext(min);
                    int n2 = minIndex;
                    indexes[n2] = indexes[n2] + 1;
                }
                if (e == r) {
                    if (this.cancelled) {
                        Arrays.fill(lists, null);
                        return;
                    }
                    ex = (Throwable)this.error.get();
                    if (ex != null) {
                        this.cancelAll();
                        Arrays.fill(lists, null);
                        a.onError(this.error.terminate());
                        return;
                    }
                    boolean empty = true;
                    for (int i = 0; i < n; ++i) {
                        if (indexes[i] == lists[i].size()) continue;
                        empty = false;
                        break;
                    }
                    if (empty) {
                        Arrays.fill(lists, null);
                        a.onComplete();
                        return;
                    }
                }
                if (e != 0L && r != Long.MAX_VALUE) {
                    this.requested.addAndGet(-e);
                }
                if ((w = this.get()) == missed) {
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }
    }
}

