/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Nono;
import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoFlatMapSignal<T>
extends Flowable<T> {
    final Nono source;
    final Function<? super Throwable, ? extends Publisher<? extends T>> onErrorMapper;
    final Callable<? extends Publisher<? extends T>> onCompleteMapper;

    NonoFlatMapSignal(Nono source, Function<? super Throwable, ? extends Publisher<? extends T>> onErrorMapper, Callable<? extends Publisher<? extends T>> onCompleteMapper) {
        this.source = source;
        this.onErrorMapper = onErrorMapper;
        this.onCompleteMapper = onCompleteMapper;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new FlatMapSignalSubscriber<T>(s, this.onErrorMapper, this.onCompleteMapper));
    }

    static final class FlatMapSignalSubscriber<T>
    extends AtomicReference<Subscription>
    implements Subscriber<Void>,
    Subscription {
        private static final long serialVersionUID = -1838187298176717779L;
        final Subscriber<? super T> downstream;
        final Function<? super Throwable, ? extends Publisher<? extends T>> onErrorMapper;
        final Callable<? extends Publisher<? extends T>> onCompleteMapper;
        final AtomicLong requested;
        Subscription upstream;

        FlatMapSignalSubscriber(Subscriber<? super T> downstream, Function<? super Throwable, ? extends Publisher<? extends T>> onErrorMapper, Callable<? extends Publisher<? extends T>> onCompleteMapper) {
            this.downstream = downstream;
            this.onErrorMapper = onErrorMapper;
            this.onCompleteMapper = onCompleteMapper;
            this.requested = new AtomicLong();
        }

        public void request(long n) {
            SubscriptionHelper.deferredRequest((AtomicReference)this, (AtomicLong)this.requested, (long)n);
        }

        public void cancel() {
            this.upstream.cancel();
            SubscriptionHelper.cancel((AtomicReference)this);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(Void t) {
        }

        public void onError(Throwable t) {
            Publisher p;
            try {
                p = (Publisher)ObjectHelper.requireNonNull((Object)this.onErrorMapper.apply((Object)t), (String)"The onErrorMapper returned a null Nono");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.downstream.onError(ex);
                return;
            }
            p.subscribe((Subscriber)new InnerSubscriber());
        }

        public void onComplete() {
            Publisher p;
            try {
                p = (Publisher)ObjectHelper.requireNonNull(this.onCompleteMapper.call(), (String)"The onCompleteMapper returned a null Nono");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.downstream.onError(ex);
                return;
            }
            p.subscribe((Subscriber)new InnerSubscriber());
        }

        void innerSubscribe(Subscription s) {
            SubscriptionHelper.deferredSetOnce((AtomicReference)this, (AtomicLong)this.requested, (Subscription)s);
        }

        final class InnerSubscriber
        implements Subscriber<T> {
            final Subscriber<? super T> a;

            InnerSubscriber() {
                this.a = FlatMapSignalSubscriber.this.downstream;
            }

            public void onSubscribe(Subscription s) {
                FlatMapSignalSubscriber.this.innerSubscribe(s);
            }

            public void onNext(T t) {
                this.a.onNext(t);
            }

            public void onError(Throwable t) {
                this.a.onError(t);
            }

            public void onComplete() {
                this.a.onComplete();
            }
        }
    }
}

