/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.BasicRefQueueSubscription;
import hu.akarnokd.rxjava2.basetypes.Nono;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoTimer
extends Nono {
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;

    NonoTimer(long delay, TimeUnit unit, Scheduler scheduler) {
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        TimerSubscription parent = new TimerSubscription(s);
        s.onSubscribe((Subscription)parent);
        DisposableHelper.replace((AtomicReference)parent, (Disposable)this.scheduler.scheduleDirect((Runnable)parent, this.delay, this.unit));
    }

    static final class TimerSubscription
    extends BasicRefQueueSubscription<Void, Disposable>
    implements Runnable {
        private static final long serialVersionUID = 3940118717227297027L;
        final Subscriber<? super Void> downstream;

        TimerSubscription(Subscriber<? super Void> downstream) {
            this.downstream = downstream;
        }

        @Override
        public int requestFusion(int mode) {
            return mode & 2;
        }

        @Override
        public Void poll() throws Exception {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
        }

        @Override
        public void request(long n) {
        }

        public void cancel() {
            DisposableHelper.dispose((AtomicReference)this);
        }

        @Override
        public void run() {
            this.downstream.onComplete();
        }
    }
}

