/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.BasicNonoIntQueueSubscription;
import hu.akarnokd.rxjava2.basetypes.Nono;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoUsing<R>
extends Nono {
    final Callable<R> resourceSupplier;
    final Function<? super R, ? extends Nono> sourceSupplier;
    final Consumer<? super R> disposer;
    final boolean eager;

    NonoUsing(Callable<R> resourceSupplier, Function<? super R, ? extends Nono> sourceSupplier, Consumer<? super R> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.sourceSupplier = sourceSupplier;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        Nono np;
        R resource;
        try {
            resource = this.resourceSupplier.call();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptySubscription.error((Throwable)ex, s);
            return;
        }
        try {
            np = (Nono)ObjectHelper.requireNonNull((Object)this.sourceSupplier.apply(resource), (String)"The sourceSupplier returned a null Nono");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal((Throwable)ex2);
            if (this.eager) {
                CompositeException ex2;
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal((Throwable)exc);
                    ex2 = new CompositeException(new Throwable[]{ex2, exc});
                }
                EmptySubscription.error((Throwable)ex2, s);
            } else {
                EmptySubscription.error((Throwable)ex2, s);
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal((Throwable)exc);
                    RxJavaPlugins.onError((Throwable)exc);
                }
            }
            return;
        }
        np.subscribe(new UsingSubscriber<R>((Subscriber<Void>)s, resource, this.disposer, this.eager));
    }

    static final class UsingSubscriber<R>
    extends BasicNonoIntQueueSubscription
    implements Subscriber<Void> {
        final Subscriber<? super Void> downstream;
        final Consumer<? super R> disposer;
        final boolean eager;
        Subscription upstream;
        R resource;
        private static final long serialVersionUID = 5500674592438910341L;

        UsingSubscriber(Subscriber<? super Void> downstream, R resource, Consumer<? super R> disposer, boolean eager) {
            this.downstream = downstream;
            this.resource = resource;
            this.disposer = disposer;
            this.eager = eager;
        }

        public void cancel() {
            if (this.compareAndSet(0, 1)) {
                this.disposeFinally();
            }
        }

        void disposeFinally() {
            try {
                this.disposer.accept(this.resource);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                RxJavaPlugins.onError((Throwable)ex);
            }
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(Void t) {
        }

        public void onError(Throwable t) {
            if (this.eager && this.compareAndSet(0, 1)) {
                try {
                    this.disposer.accept(this.resource);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    t = new CompositeException(new Throwable[]{t, ex});
                }
            }
            this.downstream.onError(t);
            if (!this.eager && this.compareAndSet(0, 1)) {
                this.disposeFinally();
            }
        }

        public void onComplete() {
            if (this.eager && this.compareAndSet(0, 1)) {
                try {
                    this.disposer.accept(this.resource);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.downstream.onError(ex);
                    return;
                }
            }
            this.downstream.onComplete();
            if (!this.eager && this.compareAndSet(0, 1)) {
                this.disposeFinally();
            }
        }
    }
}

