/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Perhaps;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class PerhapsTimeout<T>
extends Perhaps<T> {
    final Perhaps<T> source;
    final Publisher<?> other;
    final Perhaps<? extends T> fallback;

    PerhapsTimeout(Perhaps<T> source, Publisher<?> other, Perhaps<? extends T> fallback) {
        this.source = source;
        this.other = other;
        this.fallback = fallback;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        TimeoutSubscriber<? extends T> parent = new TimeoutSubscriber<T>(s, this.fallback);
        s.onSubscribe(parent);
        this.other.subscribe((Subscriber)parent.other);
        this.source.subscribe(parent);
    }

    static final class TimeoutSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -2613153829201889588L;
        final AtomicReference<Subscription> upstream = new AtomicReference();
        final Perhaps<? extends T> fallback;
        final OtherSubscriber other;
        final FallbackSubscriber fallbackSubscriber;
        final AtomicBoolean once;

        TimeoutSubscriber(Subscriber<? super T> downstream, Perhaps<? extends T> fallback) {
            super(downstream);
            this.fallback = fallback;
            this.once = new AtomicBoolean();
            this.other = new OtherSubscriber();
            this.fallbackSubscriber = fallback != null ? new FallbackSubscriber() : null;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this.upstream, (Subscription)s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            if (this.once.compareAndSet(false, true)) {
                SubscriptionHelper.cancel((AtomicReference)this.other);
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            if (this.once.compareAndSet(false, true)) {
                SubscriptionHelper.cancel((AtomicReference)this.other);
                Object v = this.value;
                if (v != null) {
                    this.complete(this.value);
                } else {
                    this.downstream.onComplete();
                }
            }
        }

        void otherComplete() {
            SubscriptionHelper.cancel(this.upstream);
            if (this.once.compareAndSet(false, true)) {
                Perhaps<T> f = this.fallback;
                if (f != null) {
                    f.subscribe(this.fallbackSubscriber);
                } else {
                    this.downstream.onError((Throwable)new TimeoutException());
                }
            }
        }

        void otherError(Throwable ex) {
            if (this.once.compareAndSet(false, true)) {
                SubscriptionHelper.cancel(this.upstream);
                this.downstream.onError(ex);
            } else {
                RxJavaPlugins.onError((Throwable)ex);
            }
        }

        public void cancel() {
            super.cancel();
            SubscriptionHelper.cancel(this.upstream);
            SubscriptionHelper.cancel((AtomicReference)this.other);
            FallbackSubscriber fs = this.fallbackSubscriber;
            if (fs != null) {
                SubscriptionHelper.cancel((AtomicReference)fs);
            }
        }

        void fallbackError(Throwable ex) {
            this.downstream.onError(ex);
        }

        void fallbackComplete(T v) {
            if (v != null) {
                this.complete(v);
            } else {
                this.downstream.onComplete();
            }
        }

        final class FallbackSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<T> {
            private static final long serialVersionUID = -1360947483517311225L;
            T v;

            FallbackSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(T t) {
                this.v = t;
            }

            public void onError(Throwable t) {
                TimeoutSubscriber.this.fallbackError(t);
            }

            public void onComplete() {
                Object val = this.v;
                this.v = null;
                TimeoutSubscriber.this.fallbackComplete(val);
            }
        }

        final class OtherSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<Object> {
            private static final long serialVersionUID = -8725214806550415150L;
            boolean once;

            OtherSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(Object t) {
                if (!this.once) {
                    this.once = true;
                    ((Subscription)this.get()).cancel();
                    TimeoutSubscriber.this.otherComplete();
                }
            }

            public void onError(Throwable t) {
                if (!this.once) {
                    this.once = true;
                    TimeoutSubscriber.this.otherError(t);
                } else {
                    RxJavaPlugins.onError((Throwable)t);
                }
            }

            public void onComplete() {
                if (!this.once) {
                    this.once = true;
                    TimeoutSubscriber.this.otherComplete();
                }
            }
        }
    }
}

