/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Perhaps;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class PerhapsZipArray<T, R>
extends Perhaps<R> {
    final Perhaps<? extends T>[] sources;
    final Function<? super Object[], ? extends R> zipper;

    PerhapsZipArray(Perhaps<? extends T>[] sources, Function<? super Object[], ? extends R> zipper) {
        this.sources = sources;
        this.zipper = zipper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        Perhaps<? extends T>[] srcs = this.sources;
        int n = srcs.length;
        ZipCoordinator<? extends T, R> parent = new ZipCoordinator<T, R>(s, this.zipper, n);
        s.onSubscribe(parent);
        parent.subscribe(srcs, n);
    }

    static final class ZipCoordinator<T, R>
    extends DeferredScalarSubscription<R> {
        private static final long serialVersionUID = 278835184144033561L;
        final Function<? super Object[], ? extends R> zipper;
        final AtomicInteger wip;
        final ZipInnerSubscriber<T, R>[] subscribers;
        final Object[] values;

        ZipCoordinator(Subscriber<? super R> downstream, Function<? super Object[], ? extends R> zipper, int n) {
            super(downstream);
            this.zipper = zipper;
            this.wip = new AtomicInteger(n);
            this.subscribers = new ZipInnerSubscriber[n];
            for (int i = 0; i < n; ++i) {
                this.subscribers[i] = new ZipInnerSubscriber(i, this);
            }
            this.values = new Object[n];
        }

        void subscribe(Perhaps<? extends T>[] sources, int n) {
            ZipInnerSubscriber<T, R>[] subs = this.subscribers;
            AtomicInteger w = this.wip;
            for (int i = 0; i < n && w.get() > 0; ++i) {
                sources[i].subscribe(subs[i]);
            }
        }

        void innerNext(int index, T value) {
            this.values[index] = value;
            if (this.wip.decrementAndGet() == 0) {
                Object v;
                try {
                    v = this.zipper.apply((Object)this.values);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.downstream.onError(ex);
                    return;
                }
                Arrays.fill(this.values, (Object)this);
                this.complete(v);
            }
        }

        void innerError(int index, Throwable error) {
            if (this.wip.getAndSet(0) > 0) {
                this.cancel(index);
                Arrays.fill(this.values, (Object)this);
                this.downstream.onError(error);
            } else {
                RxJavaPlugins.onError((Throwable)error);
            }
        }

        void innerComplete(int index) {
            if (this.values[index] == null && this.wip.getAndSet(0) > 0) {
                this.cancel(index);
                Arrays.fill(this.values, (Object)this);
                this.downstream.onComplete();
            }
        }

        public void cancel() {
            super.cancel();
            this.cancel(-1);
        }

        void cancel(int index) {
            ZipInnerSubscriber<T, R>[] subs = this.subscribers;
            for (int i = 0; i < subs.length; ++i) {
                if (i == index) continue;
                SubscriptionHelper.cancel(subs[i]);
            }
        }

        static final class ZipInnerSubscriber<T, R>
        extends AtomicReference<Subscription>
        implements Subscriber<T> {
            private static final long serialVersionUID = 2125487621013035317L;
            final ZipCoordinator<T, R> parent;
            final int index;

            ZipInnerSubscriber(int index, ZipCoordinator<T, R> parent) {
                this.index = index;
                this.parent = parent;
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(T t) {
                this.parent.innerNext(this.index, t);
            }

            public void onError(Throwable t) {
                this.parent.innerError(this.index, t);
            }

            public void onComplete() {
                this.parent.innerComplete(this.index);
            }
        }
    }
}

