/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Solo;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloZipArray<T, R>
extends Solo<R> {
    final Solo<? extends T>[] sources;
    final Function<? super Object[], ? extends R> zipper;

    SoloZipArray(Solo<? extends T>[] sources, Function<? super Object[], ? extends R> zipper) {
        this.sources = sources;
        this.zipper = zipper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        Solo<? extends T>[] a = this.sources;
        int n = a.length;
        ZipCoordinator<? extends T, R> parent = new ZipCoordinator<T, R>(s, this.zipper, n);
        s.onSubscribe(parent);
        parent.subscribe(a, n);
    }

    static final class ZipCoordinator<T, R>
    extends DeferredScalarSubscription<R> {
        private static final long serialVersionUID = -4130106888008958190L;
        final Function<? super Object[], ? extends R> zipper;
        final Object[] values;
        final ZipSubscriber<T, R>[] subscribers;
        final AtomicInteger wip;

        ZipCoordinator(Subscriber<? super R> downstream, Function<? super Object[], ? extends R> zipper, int n) {
            super(downstream);
            this.zipper = zipper;
            this.values = new Object[n];
            ZipSubscriber[] a = new ZipSubscriber[n];
            for (int i = 0; i < n; ++i) {
                a[i] = new ZipSubscriber(i, this);
            }
            this.subscribers = a;
            this.wip = new AtomicInteger(n);
        }

        void subscribe(Solo<? extends T>[] sources, int n) {
            AtomicInteger w = this.wip;
            ZipSubscriber<T, R>[] a = this.subscribers;
            for (int i = 0; i < n; ++i) {
                if (w.get() <= 0) continue;
                Solo<T> solo = sources[i];
                if (solo == null) {
                    this.onError(i, new NullPointerException("One of the source Solo is null"));
                    break;
                }
                solo.subscribe(a[i]);
            }
        }

        void onSuccess(int index, T value) {
            this.values[index] = value;
            if (this.wip.decrementAndGet() == 0) {
                Object v;
                try {
                    v = ObjectHelper.requireNonNull((Object)this.zipper.apply((Object)this.values), (String)"The zipper returned a null value");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    Arrays.fill(this.values, null);
                    this.downstream.onError(ex);
                    return;
                }
                Arrays.fill(this.values, null);
                this.complete(v);
            }
        }

        void onError(int index, Throwable t) {
            if (this.wip.getAndSet(0) > 0) {
                Arrays.fill(this.values, null);
                for (ZipSubscriber<T, R> inner : this.subscribers) {
                    inner.cancel();
                }
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void cancel() {
            super.cancel();
            if (this.wip.getAndSet(0) > 0) {
                Arrays.fill(this.values, null);
                for (ZipSubscriber<T, R> inner : this.subscribers) {
                    inner.cancel();
                }
            }
        }

        static final class ZipSubscriber<T, R>
        extends AtomicReference<Subscription>
        implements Subscriber<T> {
            private static final long serialVersionUID = -4715238780191248967L;
            final int index;
            final ZipCoordinator<T, R> parent;

            ZipSubscriber(int index, ZipCoordinator<T, R> parent) {
                this.index = index;
                this.parent = parent;
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(T t) {
                this.parent.onSuccess(this.index, t);
            }

            public void onError(Throwable t) {
                this.parent.onError(this.index, t);
            }

            public void onComplete() {
            }

            void cancel() {
                SubscriptionHelper.cancel((AtomicReference)this);
            }
        }
    }
}

