/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.debug.validator;

import hu.akarnokd.rxjava2.debug.validator.MultipleOnSubscribeCallsException;
import hu.akarnokd.rxjava2.debug.validator.MultipleTerminationsException;
import hu.akarnokd.rxjava2.debug.validator.NullOnErrorParameterException;
import hu.akarnokd.rxjava2.debug.validator.NullOnSubscribeParameterException;
import hu.akarnokd.rxjava2.debug.validator.NullOnSuccessParameterException;
import hu.akarnokd.rxjava2.debug.validator.OnSubscribeNotCalledException;
import hu.akarnokd.rxjava2.debug.validator.OnSuccessAfterTerminationException;
import hu.akarnokd.rxjava2.debug.validator.ProtocolNonConformanceException;
import hu.akarnokd.rxjava2.functions.PlainConsumer;
import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;

final class MaybeValidator<T>
extends Maybe<T> {
    final Maybe<T> source;
    final PlainConsumer<ProtocolNonConformanceException> onViolation;

    MaybeValidator(Maybe<T> source, PlainConsumer<ProtocolNonConformanceException> onViolation) {
        this.source = source;
        this.onViolation = onViolation;
    }

    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new ValidatorConsumer<T>(observer, this.onViolation));
    }

    static final class ValidatorConsumer<T>
    implements MaybeObserver<T>,
    Disposable {
        final MaybeObserver<? super T> downstream;
        final PlainConsumer<ProtocolNonConformanceException> onViolation;
        Disposable upstream;
        boolean done;

        ValidatorConsumer(MaybeObserver<? super T> downstream, PlainConsumer<ProtocolNonConformanceException> onViolation) {
            this.downstream = downstream;
            this.onViolation = onViolation;
        }

        public void onSubscribe(Disposable d) {
            Disposable u;
            if (d == null) {
                this.onViolation.accept(new NullOnSubscribeParameterException());
            }
            if ((u = this.upstream) != null) {
                this.onViolation.accept(new MultipleOnSubscribeCallsException());
            }
            this.upstream = d;
            this.downstream.onSubscribe((Disposable)this);
        }

        public void onSuccess(T t) {
            if (t == null) {
                this.onViolation.accept(new NullOnSuccessParameterException());
            }
            if (this.upstream == null) {
                this.onViolation.accept(new OnSubscribeNotCalledException());
            }
            if (this.done) {
                this.onViolation.accept(new OnSuccessAfterTerminationException());
            } else {
                this.done = true;
                this.downstream.onSuccess(t);
            }
        }

        public void onError(Throwable e) {
            if (e == null) {
                this.onViolation.accept(new NullOnErrorParameterException());
            }
            if (this.upstream == null) {
                this.onViolation.accept(new OnSubscribeNotCalledException(e));
            }
            if (this.done) {
                this.onViolation.accept(new MultipleTerminationsException(e));
            } else {
                this.done = true;
                this.downstream.onError(e);
            }
        }

        public void onComplete() {
            if (this.upstream == null) {
                OnSubscribeNotCalledException ex = new OnSubscribeNotCalledException();
                this.onViolation.accept(ex);
            }
            if (this.done) {
                this.onViolation.accept(new MultipleTerminationsException());
            } else {
                this.done = true;
                this.downstream.onComplete();
            }
        }

        public void dispose() {
            this.upstream.dispose();
        }

        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }
    }
}

