/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.CompletableTransformer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

final class CompletableFlatMapSignalCompletable
extends Completable
implements CompletableTransformer {
    final Completable source;
    final Callable<? extends CompletableSource> onCompleteHandler;
    final Function<? super Throwable, ? extends CompletableSource> onErrorHandler;

    CompletableFlatMapSignalCompletable(Completable source, Callable<? extends CompletableSource> onCompleteHandler, Function<? super Throwable, ? extends CompletableSource> onErrorHandler) {
        this.source = source;
        this.onCompleteHandler = onCompleteHandler;
        this.onErrorHandler = onErrorHandler;
    }

    public CompletableSource apply(Completable upstream) {
        return new CompletableFlatMapSignalCompletable(upstream, this.onCompleteHandler, this.onErrorHandler);
    }

    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe((CompletableObserver)new FlatMapSignalConsumer(observer, this.onCompleteHandler, this.onErrorHandler));
    }

    static final class FlatMapSignalConsumer
    implements CompletableObserver,
    Disposable {
        final SignalConsumer consumer;
        final Callable<? extends CompletableSource> onCompleteHandler;
        final Function<? super Throwable, ? extends CompletableSource> onErrorHandler;

        FlatMapSignalConsumer(CompletableObserver downstream, Callable<? extends CompletableSource> onCompleteHandler, Function<? super Throwable, ? extends CompletableSource> onErrorHandler) {
            this.consumer = new SignalConsumer(downstream);
            this.onCompleteHandler = onCompleteHandler;
            this.onErrorHandler = onErrorHandler;
        }

        public void dispose() {
            DisposableHelper.dispose((AtomicReference)this.consumer);
        }

        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)((Disposable)this.consumer.get()));
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)((Disposable)this.consumer.get()), (Disposable)d)) {
                this.consumer.lazySet(d);
                this.consumer.downstream.onSubscribe((Disposable)this);
            }
        }

        public void onComplete() {
            CompletableSource next;
            try {
                next = (CompletableSource)ObjectHelper.requireNonNull((Object)this.onCompleteHandler.call(), (String)"The onCompleteHandler returned a null CompletableSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe((CompletableObserver)this.consumer);
        }

        public void onError(Throwable e) {
            CompletableSource next;
            try {
                next = (CompletableSource)ObjectHelper.requireNonNull((Object)this.onErrorHandler.apply((Object)e), (String)"The onErrorHandler returned a null CompletableSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe((CompletableObserver)this.consumer);
        }

        static final class SignalConsumer
        extends AtomicReference<Disposable>
        implements CompletableObserver {
            private static final long serialVersionUID = 314442824941893429L;
            final CompletableObserver downstream;

            SignalConsumer(CompletableObserver downstream) {
                this.downstream = downstream;
            }

            public void onSubscribe(Disposable d) {
                DisposableHelper.replace((AtomicReference)this, (Disposable)d);
            }

            public void onComplete() {
                this.downstream.onComplete();
            }

            public void onError(Throwable e) {
                this.downstream.onError(e);
            }
        }
    }
}

