/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Completable;
import io.reactivex.CompletableConverter;
import io.reactivex.CompletableObserver;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class CompletableFlatMapSignalFlowable<R>
extends Flowable<R>
implements CompletableConverter<Flowable<R>> {
    final Completable source;
    final Callable<? extends Publisher<? extends R>> onCompleteHandler;
    final Function<? super Throwable, ? extends Publisher<? extends R>> onErrorHandler;

    CompletableFlatMapSignalFlowable(Completable source, Callable<? extends Publisher<? extends R>> onCompleteHandler, Function<? super Throwable, ? extends Publisher<? extends R>> onErrorHandler) {
        this.source = source;
        this.onCompleteHandler = onCompleteHandler;
        this.onErrorHandler = onErrorHandler;
    }

    public Flowable<R> apply(Completable t) {
        return new CompletableFlatMapSignalFlowable<R>(t, this.onCompleteHandler, this.onErrorHandler);
    }

    protected void subscribeActual(Subscriber<? super R> subscriber) {
        this.source.subscribe(new FlatMapSignalConsumer<R>(subscriber, this.onCompleteHandler, this.onErrorHandler));
    }

    static final class FlatMapSignalConsumer<R>
    implements CompletableObserver,
    Subscription {
        final SignalConsumer<R> consumer;
        final Callable<? extends Publisher<? extends R>> onCompleteHandler;
        final Function<? super Throwable, ? extends Publisher<? extends R>> onErrorHandler;
        Disposable upstream;

        FlatMapSignalConsumer(Subscriber<? super R> downstream, Callable<? extends Publisher<? extends R>> onCompleteHandler, Function<? super Throwable, ? extends Publisher<? extends R>> onErrorHandler) {
            this.consumer = new SignalConsumer<R>(downstream);
            this.onCompleteHandler = onCompleteHandler;
            this.onErrorHandler = onErrorHandler;
        }

        public void cancel() {
            this.upstream.dispose();
            SubscriptionHelper.cancel(this.consumer);
        }

        public void request(long n) {
            SubscriptionHelper.deferredRequest(this.consumer, (AtomicLong)this.consumer.requested, (long)n);
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)this.upstream, (Disposable)d)) {
                this.upstream = d;
                this.consumer.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onComplete() {
            Publisher next;
            try {
                next = (Publisher)ObjectHelper.requireNonNull(this.onCompleteHandler.call(), (String)"The onCompleteHandler returned a null Publisher");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        public void onError(Throwable e) {
            Publisher next;
            try {
                next = (Publisher)ObjectHelper.requireNonNull((Object)this.onErrorHandler.apply((Object)e), (String)"The onErrorHandler returned a null Publisher");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        static final class SignalConsumer<R>
        extends AtomicReference<Subscription>
        implements FlowableSubscriber<R> {
            private static final long serialVersionUID = 314442824941893429L;
            final Subscriber<? super R> downstream;
            final AtomicLong requested;

            SignalConsumer(Subscriber<? super R> downstream) {
                this.downstream = downstream;
                this.requested = new AtomicLong();
            }

            public void onSubscribe(Subscription s) {
                SubscriptionHelper.deferredSetOnce((AtomicReference)this, (AtomicLong)this.requested, (Subscription)s);
            }

            public void onNext(R t) {
                this.downstream.onNext(t);
            }

            public void onComplete() {
                this.downstream.onComplete();
            }

            public void onError(Throwable e) {
                this.downstream.onError(e);
            }
        }
    }
}

