/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.FlowableTransformer;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.EmptySubscription;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableErrorJump<T, R>
extends Flowable<R>
implements FlowableTransformer<T, R> {
    final Flowable<T> source;
    final FlowableTransformer<T, R> transformer;

    FlowableErrorJump(Flowable<T> source, FlowableTransformer<T, R> transformer) {
        this.source = source;
        this.transformer = transformer;
    }

    public Publisher<R> apply(Flowable<T> upstream) {
        return new FlowableErrorJump<T, R>(upstream, this.transformer);
    }

    protected void subscribeActual(Subscriber<? super R> s) {
        Publisher downstream;
        ErrorJumpFront<T, ? super R> front = new ErrorJumpFront<T, R>(this.source, s);
        try {
            downstream = (Publisher)ObjectHelper.requireNonNull((Object)this.transformer.apply(front), (String)"The transformer returned a null Publisher");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptySubscription.error((Throwable)ex, s);
            return;
        }
        downstream.subscribe((Subscriber)front.end);
    }

    static final class ErrorJumpFront<T, R>
    extends Flowable<T>
    implements FlowableSubscriber<T>,
    Subscription {
        final Flowable<T> source;
        final AtomicReference<Subscriber<? super T>> middle;
        final EndSubscriber end;
        Subscription upstream;

        ErrorJumpFront(Flowable<T> source, Subscriber<? super R> downstream) {
            this.source = source;
            this.middle = new AtomicReference();
            this.end = new EndSubscriber(downstream);
        }

        protected void subscribeActual(Subscriber<? super T> s) {
            if (this.middle.compareAndSet(null, s)) {
                this.source.subscribe((FlowableSubscriber)this);
            } else {
                EmptySubscription.error((Throwable)new IllegalStateException("Only one Subscriber allowed"), s);
            }
        }

        public void onSubscribe(Subscription s) {
            this.upstream = s;
            this.middle.get().onSubscribe((Subscription)this);
        }

        public void onNext(T t) {
            this.middle.get().onNext(t);
        }

        public void onError(Throwable t) {
            this.end.set(t);
            this.middle.get().onComplete();
        }

        public void onComplete() {
            this.middle.get().onComplete();
        }

        public void request(long n) {
            this.upstream.request(n);
        }

        public void cancel() {
            this.upstream.cancel();
        }

        final class EndSubscriber
        extends AtomicReference<Throwable>
        implements FlowableSubscriber<R>,
        Subscription {
            private static final long serialVersionUID = -5718512540714037078L;
            final Subscriber<? super R> downstream;
            Subscription upstream;

            EndSubscriber(Subscriber<? super R> downstream) {
                this.downstream = downstream;
            }

            public void onSubscribe(Subscription s) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }

            public void onNext(R t) {
                this.downstream.onNext(t);
            }

            public void onError(Throwable t) {
                Throwable ex = (Throwable)this.get();
                if (ex != null) {
                    t = new CompositeException(new Throwable[]{ex, t});
                }
                this.downstream.onError(t);
            }

            public void onComplete() {
                Throwable ex = (Throwable)this.get();
                if (ex != null) {
                    this.downstream.onError(ex);
                } else {
                    this.downstream.onComplete();
                }
            }

            public void request(long n) {
                this.upstream.request(n);
            }

            public void cancel() {
                this.upstream.cancel();
            }
        }
    }
}

