/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.subscribers.DeferredScalarSubscriber;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class FlowableIndexOf<T>
extends Flowable<Long>
implements FlowableTransformer<T, Long> {
    final Flowable<T> source;
    final Predicate<? super T> predicate;

    FlowableIndexOf(Flowable<T> source, Predicate<? super T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    public Publisher<Long> apply(Flowable<T> upstream) {
        return new FlowableIndexOf<T>(upstream, this.predicate);
    }

    protected void subscribeActual(Subscriber<? super Long> s) {
        this.source.subscribe(new IndexOfSubscriber<T>(s, this.predicate));
    }

    static final class IndexOfSubscriber<T>
    extends DeferredScalarSubscriber<T, Long> {
        private static final long serialVersionUID = 4809092721669178986L;
        final Predicate<? super T> predicate;
        long index;
        boolean found;

        IndexOfSubscriber(Subscriber<? super Long> downstream, Predicate<? super T> predicate) {
            super(downstream);
            this.predicate = predicate;
        }

        public void onNext(T t) {
            try {
                long idx = this.index;
                if (this.predicate.test(t)) {
                    this.found = true;
                    this.upstream.cancel();
                    this.complete(idx);
                    return;
                }
                this.index = idx + 1L;
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.found = true;
                this.upstream.cancel();
                this.onError(ex);
                return;
            }
        }

        public void onComplete() {
            if (!this.found) {
                this.complete(-1L);
            }
        }
    }
}

