/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Scheduler;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableSpanout<T>
extends Flowable<T>
implements FlowableTransformer<T, T> {
    final Publisher<T> source;
    final long initialSpan;
    final long betweenSpan;
    final Scheduler scheduler;
    final boolean delayError;
    final int bufferSize;

    FlowableSpanout(Publisher<T> source, long initialSpan, long betweenSpan, TimeUnit unit, Scheduler scheduler, boolean delayError, int bufferSize) {
        this.source = source;
        this.initialSpan = unit.toNanos(initialSpan);
        this.betweenSpan = unit.toNanos(betweenSpan);
        this.scheduler = scheduler;
        this.delayError = delayError;
        this.bufferSize = bufferSize;
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableSpanout<T>(upstream, this.initialSpan, this.betweenSpan, TimeUnit.NANOSECONDS, this.scheduler, this.delayError, this.bufferSize);
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new SpanoutSubscriber<T>(s, this.initialSpan, this.betweenSpan, this.scheduler.createWorker(), this.delayError, this.bufferSize));
    }

    static final class SpanoutSubscriber<T>
    implements Subscriber<T>,
    Subscription,
    Runnable {
        final Subscriber<? super T> downstream;
        final long initialSpan;
        final long betweenSpan;
        final Scheduler.Worker worker;
        final boolean delayError;
        final SimplePlainQueue<T> queue;
        long lastEvent;
        Subscription upstream;
        volatile Object terminalEvent;

        SpanoutSubscriber(Subscriber<? super T> downstream, long initialSpan, long betweenSpan, Scheduler.Worker worker, boolean delayError, int bufferSize) {
            this.downstream = downstream;
            this.initialSpan = initialSpan;
            this.betweenSpan = betweenSpan;
            this.worker = worker;
            this.delayError = delayError;
            this.lastEvent = -1L;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.queue.offer(t);
            long now = this.worker.now(TimeUnit.NANOSECONDS);
            long last = this.lastEvent;
            long between = this.betweenSpan;
            if (last == -1L) {
                this.lastEvent = now + between + this.initialSpan;
                this.worker.schedule((Runnable)this, this.initialSpan, TimeUnit.NANOSECONDS);
            } else if (last < now) {
                this.lastEvent = now + between;
                this.worker.schedule((Runnable)this);
            } else {
                this.lastEvent = last + between;
                long next = last - now;
                this.worker.schedule((Runnable)this, next, TimeUnit.NANOSECONDS);
            }
        }

        public void onError(Throwable t) {
            this.terminalEvent = t;
            if (this.delayError) {
                long now = this.worker.now(TimeUnit.NANOSECONDS);
                this.worker.schedule((Runnable)this, this.lastEvent - now - this.betweenSpan, TimeUnit.NANOSECONDS);
            } else {
                this.worker.schedule((Runnable)this);
            }
        }

        public void onComplete() {
            this.terminalEvent = this;
            long now = this.worker.now(TimeUnit.NANOSECONDS);
            this.worker.schedule((Runnable)this, this.lastEvent - now - this.betweenSpan, TimeUnit.NANOSECONDS);
        }

        public void request(long n) {
            this.upstream.request(n);
        }

        public void cancel() {
            this.worker.dispose();
            this.upstream.cancel();
        }

        @Override
        public void run() {
            boolean empty;
            Object o = this.terminalEvent;
            if (o != null && o != this && !this.delayError) {
                this.queue.clear();
                this.downstream.onError((Throwable)o);
                this.worker.dispose();
                return;
            }
            Object v = this.queue.poll();
            boolean bl = empty = v == null;
            if (o != null && empty) {
                if (o == this) {
                    this.downstream.onComplete();
                } else {
                    this.downstream.onError((Throwable)o);
                }
                this.worker.dispose();
                return;
            }
            if (!empty) {
                this.downstream.onNext(v);
            }
        }
    }
}

