/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.processors;

import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.processors.FlowableProcessor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class RefCountProcessor<T>
extends FlowableProcessor<T>
implements Subscription {
    final FlowableProcessor<T> actual;
    final AtomicReference<Subscription> upstream;
    final AtomicReference<RefCountSubscriber<T>[]> subscribers;
    static final RefCountSubscriber[] EMPTY = new RefCountSubscriber[0];
    static final RefCountSubscriber[] TERMINATED = new RefCountSubscriber[0];

    RefCountProcessor(FlowableProcessor<T> actual) {
        this.actual = actual;
        this.upstream = new AtomicReference();
        this.subscribers = new AtomicReference<RefCountSubscriber[]>(EMPTY);
    }

    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce(this.upstream, (Subscription)s)) {
            this.actual.onSubscribe((Subscription)this);
        }
    }

    public void onNext(T t) {
        this.actual.onNext(t);
    }

    public void onError(Throwable t) {
        this.upstream.lazySet((Subscription)SubscriptionHelper.CANCELLED);
        this.actual.onError(t);
    }

    public void onComplete() {
        this.upstream.lazySet((Subscription)SubscriptionHelper.CANCELLED);
        this.actual.onComplete();
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        RefCountSubscriber<? super T> rcs = new RefCountSubscriber<T>(s, this);
        if (!this.add(rcs)) {
            EmptySubscription.error((Throwable)new IllegalStateException("RefCountProcessor terminated"), s);
            return;
        }
        this.actual.subscribe(rcs);
    }

    public boolean hasComplete() {
        return this.actual.hasComplete();
    }

    public boolean hasThrowable() {
        return this.actual.hasThrowable();
    }

    public Throwable getThrowable() {
        return this.actual.getThrowable();
    }

    public boolean hasSubscribers() {
        return this.actual.hasSubscribers();
    }

    public void cancel() {
        SubscriptionHelper.cancel(this.upstream);
    }

    public void request(long n) {
        this.upstream.get().request(n);
    }

    boolean add(RefCountSubscriber<T> rcs) {
        RefCountSubscriber[] b;
        RefCountSubscriber<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new RefCountSubscriber[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = rcs;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    void remove(RefCountSubscriber<T> rcs) {
        RefCountSubscriber<T>[] a;
        int n;
        while ((n = (a = this.subscribers.get()).length) != 0) {
            RefCountSubscriber[] b;
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (rcs != a[i]) continue;
                j = i;
                break;
            }
            if (j < 0) break;
            if (n == 1) {
                b = TERMINATED;
            } else {
                b = new RefCountSubscriber[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            }
            if (!this.subscribers.compareAndSet(a, b)) continue;
            if (b != TERMINATED) break;
            this.cancel();
            break;
        }
    }

    static final class RefCountSubscriber<T>
    extends AtomicBoolean
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -4317488092687530631L;
        final Subscriber<? super T> downstream;
        final RefCountProcessor<T> parent;
        Subscription upstream;

        RefCountSubscriber(Subscriber<? super T> downstream, RefCountProcessor<T> parent) {
            this.downstream = downstream;
            this.parent = parent;
        }

        public void request(long n) {
            this.upstream.request(n);
        }

        public void cancel() {
            this.lazySet(true);
            this.upstream.cancel();
            this.parent.remove(this);
        }

        public void onSubscribe(Subscription s) {
            this.upstream = s;
            this.downstream.onSubscribe((Subscription)this);
        }

        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

